/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.glove.count;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.nd4j.linalg.primitives.Pair;

public class CountMap<T extends SequenceElement> {
    private volatile Map<Pair<T, T>, AtomicDouble> backingMap = new ConcurrentHashMap<Pair<T, T>, AtomicDouble>();

    public void incrementCount(T element1, T element2, double weight) {
        Pair tempEntry = new Pair(element1, element2);
        if (this.backingMap.containsKey(tempEntry)) {
            this.backingMap.get(tempEntry).addAndGet(weight);
        } else {
            this.backingMap.put(tempEntry, new AtomicDouble(weight));
        }
    }

    public void removePair(T element1, T element2) {
        Pair tempEntry = new Pair(element1, element2);
        this.backingMap.remove(tempEntry);
    }

    public void removePair(Pair<T, T> pair) {
        this.backingMap.remove(pair);
    }

    public double getCount(T element1, T element2) {
        Pair tempEntry = new Pair(element1, element2);
        if (this.backingMap.containsKey(tempEntry)) {
            return this.backingMap.get(tempEntry).get();
        }
        return 0.0;
    }

    public double getCount(Pair<T, T> pair) {
        if (this.backingMap.containsKey(pair)) {
            return this.backingMap.get(pair).get();
        }
        return 0.0;
    }

    public Iterator<Pair<T, T>> getPairIterator() {
        return new Iterator<Pair<T, T>>(){
            private Iterator<Pair<T, T>> iterator;
            {
                this.iterator = CountMap.this.backingMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Pair<T, T> next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() isn't supported here");
            }
        };
    }

    public int size() {
        return this.backingMap.size();
    }
}

