/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasDense
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasDense.class);
    private int numTrainableParams = 2;
    private boolean hasBias;

    public KerasDense(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasDense(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasDense(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.hasBias = KerasLayerUtils.getHasBiasFromConfig(layerConfig, this.conf);
        this.numTrainableParams = this.hasBias ? 2 : 1;
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint weightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_W_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        Pair<WeightInit, Distribution> init = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        WeightInit weightInit = (WeightInit)init.getFirst();
        Distribution distribution = (Distribution)init.getSecond();
        DenseLayer.Builder builder = ((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().name(this.layerName)).nOut(KerasLayerUtils.getNOutFromConfig(layerConfig, this.conf))).dropOut(this.dropout)).activation(KerasActivationUtils.getIActivationFromConfig(layerConfig, this.conf))).weightInit(weightInit)).biasInit(0.0)).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).hasBias(this.hasBias);
        if (distribution != null) {
            builder.dist(distribution);
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (weightConstraint != null) {
            builder.constrainWeights(new LayerConstraint[]{weightConstraint});
        }
        this.layer = builder.build();
    }

    public DenseLayer getDenseLayer() {
        return (DenseLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        InputPreProcessor preprocessor = this.getInputPreprocessor(inputType[0]);
        if (preprocessor != null) {
            return this.getDenseLayer().getOutputType(-1, preprocessor.getOutputType(inputType[0]));
        }
        return this.getDenseLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public int getNumParams() {
        return this.numTrainableParams;
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        this.weights = new HashMap();
        if (!weights.containsKey(this.conf.getKERAS_PARAM_NAME_W())) {
            throw new InvalidKerasConfigurationException("Parameter " + this.conf.getKERAS_PARAM_NAME_W() + " does not exist in weights");
        }
        this.weights.put("W", weights.get(this.conf.getKERAS_PARAM_NAME_W()));
        if (this.hasBias) {
            if (weights.containsKey(this.conf.getKERAS_PARAM_NAME_B())) {
                this.weights.put("b", weights.get(this.conf.getKERAS_PARAM_NAME_B()));
            } else {
                throw new InvalidKerasConfigurationException("Parameter " + this.conf.getKERAS_PARAM_NAME_B() + " does not exist in weights");
            }
        }
        KerasLayerUtils.removeDefaultWeights(weights, this.conf);
    }

    public int getNumTrainableParams() {
        return this.numTrainableParams;
    }

    public boolean isHasBias() {
        return this.hasBias;
    }

    public void setNumTrainableParams(int numTrainableParams) {
        this.numTrainableParams = numTrainableParams;
    }

    public void setHasBias(boolean hasBias) {
        this.hasBias = hasBias;
    }

    public String toString() {
        return "KerasDense(numTrainableParams=" + this.getNumTrainableParams() + ", hasBias=" + this.isHasBias() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasDense)) {
            return false;
        }
        KerasDense other = (KerasDense)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumTrainableParams() != other.getNumTrainableParams()) {
            return false;
        }
        return this.isHasBias() == other.isHasBias();
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasDense;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumTrainableParams();
        result = result * 59 + (this.isHasBias() ? 79 : 97);
        return result;
    }
}

