/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ZeroPadding1DLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasZeroPadding1D
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasZeroPadding1D.class);

    public KerasZeroPadding1D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasZeroPadding1D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        String paddingField = this.conf.getLAYER_FIELD_ZERO_PADDING();
        ZeroPadding1DLayer.Builder builder = (ZeroPadding1DLayer.Builder)((ZeroPadding1DLayer.Builder)new ZeroPadding1DLayer.Builder(KerasConvolutionUtils.getPaddingFromConfig(layerConfig, this.conf, paddingField, 1)).name(this.layerName)).dropOut(this.dropout);
        this.layer = builder.build();
        this.vertex = null;
    }

    public ZeroPadding1DLayer getZeroPadding1DLayer() {
        return (ZeroPadding1DLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras ZeroPadding layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getZeroPadding1DLayer().getOutputType(-1, inputType[0]);
    }

    public String toString() {
        return "KerasZeroPadding1D()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasZeroPadding1D)) {
            return false;
        }
        KerasZeroPadding1D other = (KerasZeroPadding1D)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasZeroPadding1D;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

