/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FlipImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    private int flipMode;
    private int h;
    private int w;
    private int mode;

    public FlipImageTransform() {
        this(null);
    }

    public FlipImageTransform(int flipMode) {
        this(null);
        this.flipMode = flipMode;
    }

    public FlipImageTransform(Random random) {
        super(random);
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        if (mat == null) {
            return null;
        }
        this.h = mat.rows();
        this.w = mat.cols();
        this.mode = random != null ? random.nextInt(4) - 2 : this.flipMode;
        opencv_core.Mat result = new opencv_core.Mat();
        if (this.mode < -1) {
            mat.copyTo(result);
        } else {
            opencv_core.flip((opencv_core.Mat)mat, (opencv_core.Mat)result, (int)this.mode);
        }
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            float x = coordinates[i];
            float y = coordinates[i + 1];
            float x2 = (float)this.w - x - 1.0f;
            float y2 = (float)this.h - y - 1.0f;
            if (this.mode < -1) {
                transformed[i] = x;
                transformed[i + 1] = y;
                continue;
            }
            if (this.mode == 0) {
                transformed[i] = x;
                transformed[i + 1] = y2;
                continue;
            }
            if (this.mode > 0) {
                transformed[i] = x2;
                transformed[i + 1] = y;
                continue;
            }
            if (this.mode >= 0) continue;
            transformed[i] = x2;
            transformed[i + 1] = y2;
        }
        return transformed;
    }

    public int getFlipMode() {
        return this.flipMode;
    }

    public int getH() {
        return this.h;
    }

    public int getW() {
        return this.w;
    }

    public int getMode() {
        return this.mode;
    }

    public void setFlipMode(int flipMode) {
        this.flipMode = flipMode;
    }

    public void setH(int h) {
        this.h = h;
    }

    public void setW(int w) {
        this.w = w;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlipImageTransform)) {
            return false;
        }
        FlipImageTransform other = (FlipImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFlipMode() != other.getFlipMode()) {
            return false;
        }
        if (this.getH() != other.getH()) {
            return false;
        }
        if (this.getW() != other.getW()) {
            return false;
        }
        return this.getMode() == other.getMode();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FlipImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFlipMode();
        result = result * 59 + this.getH();
        result = result * 59 + this.getW();
        result = result * 59 + this.getMode();
        return result;
    }

    @Override
    public String toString() {
        return "FlipImageTransform(flipMode=" + this.getFlipMode() + ", h=" + this.getH() + ", w=" + this.getW() + ", mode=" + this.getMode() + ")";
    }
}

