/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable;

import com.google.common.math.DoubleMath;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.datavec.api.io.WritableComparable;
import org.datavec.api.io.WritableComparator;
import org.datavec.api.writable.ByteWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class IntWritable
implements WritableComparable {
    private int value;

    public IntWritable() {
    }

    public IntWritable(@JsonProperty(value="value") int value) {
        this.set(value);
    }

    public void set(int value) {
        this.value = value;
    }

    public int get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readInt();
    }

    @Override
    public void writeType(DataOutput out) throws IOException {
        out.writeShort(WritableType.Int.typeIdx());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.value);
    }

    public boolean fuzzyEquals(Writable o, double tolerance) {
        double other;
        if (o instanceof IntWritable) {
            other = ((IntWritable)o).toDouble();
        } else if (o instanceof LongWritable) {
            other = ((LongWritable)o).toDouble();
        } else if (o instanceof ByteWritable) {
            other = ((ByteWritable)o).toDouble();
        } else if (o instanceof DoubleWritable) {
            other = ((DoubleWritable)o).toDouble();
        } else if (o instanceof FloatWritable) {
            other = ((FloatWritable)o).toDouble();
        } else {
            return false;
        }
        return DoubleMath.fuzzyEquals((double)this.value, (double)other, (double)tolerance);
    }

    public boolean equals(Object o) {
        if (o instanceof ByteWritable) {
            ByteWritable other = (ByteWritable)o;
            return this.value == other.get();
        }
        if (o instanceof IntWritable) {
            IntWritable other = (IntWritable)o;
            return this.value == other.get();
        }
        if (o instanceof LongWritable) {
            LongWritable other = (LongWritable)o;
            return (long)this.value == other.get();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(Object o) {
        int thisValue = this.value;
        int thatValue = ((IntWritable)o).value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public float toFloat() {
        return this.value;
    }

    @Override
    public int toInt() {
        return this.value;
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    public WritableType getType() {
        return WritableType.Int;
    }

    static {
        WritableComparator.define(IntWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(IntWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int thatValue;
            int thisValue = Comparator.readInt(b1, s1);
            return thisValue < (thatValue = Comparator.readInt(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

