/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.datavec.api.transform.ops.IAggregableReduceOp;

public class DispatchOp<T, U>
implements IAggregableReduceOp<List<T>, List<U>> {
    @NonNull
    private List<IAggregableReduceOp<T, List<U>>> operations;

    @Override
    public <W extends IAggregableReduceOp<List<T>, List<U>>> void combine(W accu) {
        if (accu instanceof DispatchOp) {
            List<IAggregableReduceOp<T, List<U>>> otherOps = ((DispatchOp)accu).getOperations();
            if (this.operations.size() != otherOps.size()) {
                throw new IllegalArgumentException("Tried to combine() incompatible " + this.getClass().getName() + " operators: received " + otherOps.size() + " operations, expected " + this.operations.size());
            }
            for (int i = 0; i < Math.min(this.operations.size(), otherOps.size()); ++i) {
                this.operations.get(i).combine(otherOps.get(i));
            }
        } else {
            throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
        }
    }

    public void accept(List<T> ts) {
        for (int i = 0; i < Math.min(this.operations.size(), ts.size()); ++i) {
            this.operations.get(i).accept(ts.get(i));
        }
    }

    public List<U> get() {
        ArrayList res = new ArrayList();
        for (int i = 0; i < this.operations.size(); ++i) {
            res.addAll((Collection)this.operations.get(i).get());
        }
        return res;
    }

    public DispatchOp(@NonNull List<IAggregableReduceOp<T, List<U>>> operations) {
        if (operations == null) {
            throw new NullPointerException("operations is marked @NonNull but is null");
        }
        this.operations = operations;
    }

    @NonNull
    public List<IAggregableReduceOp<T, List<U>>> getOperations() {
        return this.operations;
    }
}

