/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.quality.time;

import java.io.Serializable;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.quality.columns.TimeQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.function.BiFunction;

public class TimeQualityAddFunction
implements BiFunction<TimeQuality, Writable, TimeQuality>,
Serializable {
    private final TimeMetaData meta;

    public TimeQuality apply(TimeQuality v1, Writable writable) {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        if (this.meta.isValid(writable)) {
            ++valid;
        } else if (writable instanceof NullWritable || writable instanceof Text && (writable.toString() == null || writable.toString().isEmpty())) {
            ++countMissing;
        } else {
            ++invalid;
        }
        return new TimeQuality(valid, invalid, countMissing, countTotal);
    }

    public TimeQualityAddFunction(TimeMetaData meta) {
        this.meta = meta;
    }
}

