/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform;

import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.metadata.FloatMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.writable.WritableType;

public enum ColumnType {
    String,
    Integer,
    Long,
    Double,
    Float,
    Categorical,
    Time,
    Bytes,
    Boolean,
    NDArray;


    public ColumnMetaData newColumnMetaData(String columnName) {
        switch (this) {
            case String: {
                return new StringMetaData(columnName);
            }
            case Integer: {
                return new IntegerMetaData(columnName);
            }
            case Long: {
                return new LongMetaData(columnName);
            }
            case Double: {
                return new DoubleMetaData(columnName);
            }
            case Float: {
                return new FloatMetaData(columnName);
            }
            case Time: {
                return new TimeMetaData(columnName);
            }
            case Boolean: {
                return new CategoricalMetaData(columnName, "true", "false");
            }
            case Categorical: {
                throw new UnsupportedOperationException("Cannot create new categorical column using this method: categorical state names would be unknown");
            }
            case NDArray: {
                throw new UnsupportedOperationException("Cannot create new NDArray column using this method: shape information would be unknown");
            }
        }
        throw new UnsupportedOperationException("Unknown or not supported column type: " + (Object)((Object)this));
    }

    public WritableType getWritableType() {
        switch (this) {
            case String: {
                return WritableType.Text;
            }
            case Integer: {
                return WritableType.Int;
            }
            case Long: {
                return WritableType.Long;
            }
            case Double: {
                return WritableType.Double;
            }
            case Float: {
                return WritableType.Float;
            }
            case Categorical: {
                return WritableType.Text;
            }
            case Time: {
                return WritableType.Long;
            }
            case Bytes: {
                return WritableType.Byte;
            }
            case Boolean: {
                return WritableType.Boolean;
            }
            case NDArray: {
                return WritableType.Image;
            }
        }
        throw new IllegalStateException("Unknown writable type for column type: " + (Object)((Object)this));
    }
}

