/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.converter;

import java.io.IOException;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.records.writer.RecordWriter;
import org.datavec.api.records.writer.SequenceRecordWriter;

public class RecordReaderConverter {
    private RecordReaderConverter() {
    }

    public static void convert(RecordReader reader, RecordWriter writer) throws IOException {
        RecordReaderConverter.convert(reader, writer, true);
    }

    public static void convert(RecordReader reader, RecordWriter writer, boolean closeOnCompletion) throws IOException {
        if (!reader.hasNext()) {
            throw new UnsupportedOperationException("Cannot convert RecordReader: reader has no next element");
        }
        while (reader.hasNext()) {
            writer.write(reader.next());
        }
        if (closeOnCompletion) {
            writer.close();
        }
    }

    public static void convert(SequenceRecordReader reader, SequenceRecordWriter writer) throws IOException {
        RecordReaderConverter.convert(reader, writer, true);
    }

    public static void convert(SequenceRecordReader reader, SequenceRecordWriter writer, boolean closeOnCompletion) throws IOException {
        if (!reader.hasNext()) {
            throw new UnsupportedOperationException("Cannot convert SequenceRecordReader: reader has no next element");
        }
        while (reader.hasNext()) {
            writer.write(reader.sequenceRecord());
        }
        if (closeOnCompletion) {
            writer.close();
        }
    }
}

