/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.FetchPlan;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOQueryInterruptedException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.PersistenceManager;
import org.datanucleus.api.jdo.JDOExtent;
import org.datanucleus.api.jdo.JDOFetchPlan;
import org.datanucleus.api.jdo.NucleusJDOHelper;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.store.Extent;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryTimeoutException;

public class JDOQuery
implements javax.jdo.Query,
AutoCloseable {
    private static final long serialVersionUID = -204134873012573162L;
    transient PersistenceManager pm;
    Query query;
    String language;
    JDOFetchPlan fetchPlan = null;

    public JDOQuery(PersistenceManager pm, Query query, String language) {
        this.pm = pm;
        this.query = query;
        this.language = language;
    }

    @Override
    public void close() {
        this.closeAll();
        if (this.fetchPlan != null) {
            this.fetchPlan.clearGroups();
            this.fetchPlan = null;
        }
    }

    public void close(Object queryResult) {
        this.query.close(queryResult);
    }

    public void closeAll() {
        this.query.closeAll();
    }

    public void compile() {
        try {
            this.query.compile();
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void declareImports(String imports) {
        try {
            this.query.declareImports(imports);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void declareParameters(String parameters) {
        try {
            this.query.declareExplicitParameters(parameters);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void declareVariables(String variables) {
        try {
            this.query.declareExplicitVariables(variables);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public long deletePersistentAll() {
        try {
            return this.query.deletePersistentAll();
        }
        catch (NoQueryResultsException nqre) {
            return 0L;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public long deletePersistentAll(Object ... parameters) {
        try {
            return this.query.deletePersistentAll(parameters);
        }
        catch (NoQueryResultsException nqre) {
            return 0L;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public long deletePersistentAll(Map parameters) {
        try {
            return this.query.deletePersistentAll(parameters);
        }
        catch (NoQueryResultsException nqre) {
            return 0L;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Object execute() {
        try {
            return this.query.execute();
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Object execute(Object p1) {
        try {
            return this.query.executeWithArray(new Object[]{p1});
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Object execute(Object p1, Object p2) {
        try {
            return this.query.executeWithArray(new Object[]{p1, p2});
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Object execute(Object p1, Object p2, Object p3) {
        try {
            return this.query.executeWithArray(new Object[]{p1, p2, p3});
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Object executeWithArray(Object ... parameterValues) {
        try {
            return this.query.executeWithArray(parameterValues);
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Object executeWithMap(Map parameters) {
        try {
            return this.query.executeWithMap(parameters);
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (QueryTimeoutException qte) {
            throw new JDODataStoreException("Query has timed out : " + qte.getMessage());
        }
        catch (QueryInterruptedException qie) {
            throw new JDOQueryInterruptedException("Query has been cancelled : " + qie.getMessage());
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void cancelAll() {
        try {
            this.query.cancel();
        }
        catch (NucleusException ne) {
            throw new JDOException("Error in calling Query.cancelAll. See the nested exception", (Throwable)ne);
        }
        catch (UnsupportedOperationException uoe) {
            throw new JDOUnsupportedOptionException();
        }
    }

    public void cancel(Thread thr) {
        try {
            this.query.cancel(thr);
        }
        catch (NucleusException ne) {
            throw new JDOException("Error in calling Query.cancelAll. See the nested exception", (Throwable)ne);
        }
        catch (UnsupportedOperationException uoe) {
            throw new JDOUnsupportedOptionException();
        }
    }

    public void setCandidates(javax.jdo.Extent extent) {
        try {
            if (extent == null) {
                this.query.setCandidates((Extent)null);
            } else {
                this.query.setCandidates(((JDOExtent)extent).getExtent());
            }
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setCandidates(Collection pcs) {
        try {
            this.query.setCandidates(pcs);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setClass(Class candidateClass) {
        try {
            this.query.setCandidateClass(candidateClass);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void addExtension(String key, Object value) {
        this.query.addExtension(key, value);
    }

    public void setExtensions(Map extensions) {
        this.query.setExtensions(extensions);
    }

    public FetchPlan getFetchPlan() {
        if (this.fetchPlan == null) {
            this.fetchPlan = new JDOFetchPlan(this.query.getFetchPlan());
        }
        return this.fetchPlan;
    }

    public void setFilter(String filter) {
        try {
            this.query.setFilter(filter);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setGrouping(String grouping) {
        try {
            this.query.setGrouping(grouping);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public boolean getIgnoreCache() {
        return this.query.getIgnoreCache();
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.query.setIgnoreCache(ignoreCache);
    }

    public void setOrdering(String ordering) {
        try {
            this.query.setOrdering(ordering);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public void setRange(String range) {
        try {
            this.query.setRange(range);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setRange(long fromIncl, long toExcl) {
        try {
            this.query.setRange(fromIncl, toExcl);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setResult(String result) {
        try {
            this.query.setResult(result);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setResultClass(Class result_cls) {
        try {
            this.query.setResultClass(result_cls);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setDatastoreReadTimeoutMillis(Integer timeout) {
        try {
            this.query.setDatastoreReadTimeoutMillis(timeout);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Integer getDatastoreReadTimeoutMillis() {
        return this.query.getDatastoreReadTimeoutMillis();
    }

    public void setDatastoreWriteTimeoutMillis(Integer timeout) {
        try {
            this.query.setDatastoreWriteTimeoutMillis(timeout);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Integer getDatastoreWriteTimeoutMillis() {
        return this.query.getDatastoreWriteTimeoutMillis();
    }

    public void setUnique(boolean unique) {
        try {
            this.query.setUnique(unique);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public boolean isUnmodifiable() {
        return this.query.isUnmodifiable();
    }

    public void setUnmodifiable() {
        this.query.setUnmodifiable();
    }

    public void addSubquery(javax.jdo.Query sub, String variableDecl, String candidateExpr) {
        this.addSubquery(sub, variableDecl, candidateExpr, (Map)null);
    }

    public void addSubquery(javax.jdo.Query sub, String variableDecl, String candidateExpr, String parameter) {
        HashMap<Integer, String> paramMap = new HashMap<Integer, String>();
        if (parameter != null) {
            paramMap.put(0, parameter);
        }
        this.addSubquery(sub, variableDecl, candidateExpr, paramMap);
    }

    public void addSubquery(javax.jdo.Query sub, String variableDecl, String candidateExpr, String ... parameters) {
        HashMap<Integer, String> paramMap = new HashMap<Integer, String>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                paramMap.put(i, parameters[i]);
            }
        }
        this.addSubquery(sub, variableDecl, candidateExpr, paramMap);
    }

    public void addSubquery(javax.jdo.Query sub, String variableDecl, String candidateExpr, Map parameters) {
        try {
            Query subquery = null;
            if (sub != null) {
                subquery = ((JDOQuery)sub).query;
            }
            this.query.addSubquery(subquery, variableDecl, candidateExpr, parameters);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Boolean getSerializeRead() {
        return this.query.getSerializeRead();
    }

    public void setSerializeRead(Boolean serialize) {
        this.query.setSerializeRead(serialize);
    }

    public Query getInternalQuery() {
        return this.query;
    }

    public String getLanguage() {
        return this.language;
    }

    public javax.jdo.Query saveAsNamedQuery(String name) {
        QueryMetaData qmd = new QueryMetaData(name);
        qmd.setLanguage(this.language);
        qmd.setQuery(this.query.toString());
        qmd.setResultClass(this.query.getResultClassName());
        qmd.setUnique(this.query.isUnique());
        Map queryExts = this.query.getExtensions();
        if (queryExts != null && !queryExts.isEmpty()) {
            for (Map.Entry queryExtEntry : queryExts.entrySet()) {
                qmd.addExtension((String)queryExtEntry.getKey(), "" + queryExtEntry.getValue());
            }
        }
        this.query.getExecutionContext().getMetaDataManager().registerNamedQuery(qmd);
        return this;
    }

    public String toString() {
        return this.query.toString();
    }

    public Object getNativeQuery() {
        return this.query.getNativeQuery();
    }

    public javax.jdo.Query filter(String filter) {
        this.setFilter(filter);
        return this;
    }

    public javax.jdo.Query groupBy(String grouping) {
        this.setGrouping(grouping);
        return this;
    }

    public javax.jdo.Query having(String having) {
        return this;
    }

    public javax.jdo.Query orderBy(String ordering) {
        this.setOrdering(ordering);
        return this;
    }

    public javax.jdo.Query range(long fromIncl, long toExcl) {
        this.setRange(fromIncl, toExcl);
        return this;
    }

    public javax.jdo.Query range(String range) {
        this.setRange(range);
        return this;
    }
}

