/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro.session;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.crazycake.shiro.cache.IRedisManager;
import org.crazycake.shiro.exception.SerializationException;
import org.crazycake.shiro.serializer.ObjectSerializer;
import org.crazycake.shiro.serializer.RedisSerializer;
import org.crazycake.shiro.serializer.StringSerializer;
import org.crazycake.shiro.session.SessionInMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisSessionDAO
extends AbstractSessionDAO {
    private static Logger logger = LoggerFactory.getLogger(RedisSessionDAO.class);
    private static final String DEFAULT_SESSION_KEY_PREFIX = "shiro:session:";
    private String keyPrefix = "shiro:session:";
    private static final long DEFAULT_SESSION_IN_MEMORY_TIMEOUT = 1000L;
    private long sessionInMemoryTimeout = 1000L;
    private static final boolean DEFAULT_SESSION_IN_MEMORY_ENABLED = true;
    private boolean sessionInMemoryEnabled = true;
    private static ThreadLocal sessionsInThread = new ThreadLocal();
    private static final int DEFAULT_EXPIRE = -2;
    private static final int NO_EXPIRE = -1;
    private int expire = -2;
    private static final int MILLISECONDS_IN_A_SECOND = 1000;
    private IRedisManager redisManager;
    private RedisSerializer keySerializer = new StringSerializer();
    private RedisSerializer valueSerializer = new ObjectSerializer();

    public void update(Session session) throws UnknownSessionException {
        if (this.sessionInMemoryEnabled) {
            this.removeExpiredSessionInMemory();
        }
        this.saveSession(session);
        if (this.sessionInMemoryEnabled) {
            this.setSessionToThreadLocal(session.getId(), session);
        }
    }

    private void saveSession(Session session) throws UnknownSessionException {
        byte[] value;
        byte[] key;
        if (session == null || session.getId() == null) {
            logger.error("session or session id is null");
            throw new UnknownSessionException("session or session id is null");
        }
        try {
            key = this.keySerializer.serialize(this.getRedisSessionKey(session.getId()));
            value = this.valueSerializer.serialize(session);
        }
        catch (SerializationException e) {
            logger.error("serialize session error. session id=" + String.valueOf(session.getId()));
            throw new UnknownSessionException((Throwable)e);
        }
        if (this.expire == -2) {
            this.redisManager.set(key, value, (int)(session.getTimeout() / 1000L));
            return;
        }
        if (this.expire != -1 && (long)(this.expire * 1000) < session.getTimeout()) {
            logger.warn("Redis session expire time: " + this.expire * 1000 + " is less than Session timeout: " + session.getTimeout() + " . It may cause some problems.");
        }
        this.redisManager.set(key, value, this.expire);
    }

    public void delete(Session session) {
        if (this.sessionInMemoryEnabled) {
            this.removeExpiredSessionInMemory();
        }
        if (session == null || session.getId() == null) {
            logger.error("session or session id is null");
            return;
        }
        if (this.sessionInMemoryEnabled) {
            this.delSessionFromThreadLocal(session.getId());
        }
        try {
            this.redisManager.del(this.keySerializer.serialize(this.getRedisSessionKey(session.getId())));
        }
        catch (SerializationException e) {
            logger.error("delete session error. session id=" + String.valueOf(session.getId()));
        }
    }

    public Collection<Session> getActiveSessions() {
        if (this.sessionInMemoryEnabled) {
            this.removeExpiredSessionInMemory();
        }
        HashSet<Session> sessions = new HashSet<Session>();
        try {
            Set<byte[]> keys = this.redisManager.keys(this.keySerializer.serialize(this.keyPrefix + "*"));
            if (keys != null && keys.size() > 0) {
                for (byte[] key : keys) {
                    Object deserialize = this.valueSerializer.deserialize(this.redisManager.get(key));
                    if (deserialize == null) continue;
                    sessions.add((Session)deserialize);
                }
            }
        }
        catch (SerializationException e) {
            logger.error("get active sessions error.");
        }
        return sessions;
    }

    protected Serializable doCreate(Session session) {
        if (this.sessionInMemoryEnabled) {
            this.removeExpiredSessionInMemory();
        }
        if (session == null) {
            logger.error("session is null");
            throw new UnknownSessionException("session is null");
        }
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.saveSession(session);
        return sessionId;
    }

    protected Session doReadSession(Serializable sessionId) {
        Session session;
        if (this.sessionInMemoryEnabled) {
            this.removeExpiredSessionInMemory();
        }
        if (sessionId == null) {
            logger.warn("session id is null");
            return null;
        }
        if (this.sessionInMemoryEnabled && (session = this.getSessionFromThreadLocal(sessionId)) != null) {
            return session;
        }
        session = null;
        try {
            String sessionRedisKey = this.getRedisSessionKey(sessionId);
            logger.debug("read session: " + sessionRedisKey + " from Redis");
            session = (Session)this.valueSerializer.deserialize(this.redisManager.get(this.keySerializer.serialize(sessionRedisKey)));
            if (this.sessionInMemoryEnabled) {
                this.setSessionToThreadLocal(sessionId, session);
            }
        }
        catch (SerializationException e) {
            logger.error("read session error. sessionId: " + String.valueOf(sessionId));
        }
        return session;
    }

    private void setSessionToThreadLocal(Serializable sessionId, Session session) {
        this.initSessionsInThread();
        Map sessionMap = (Map)sessionsInThread.get();
        sessionMap.put(sessionId, this.createSessionInMemory(session));
    }

    private void delSessionFromThreadLocal(Serializable sessionId) {
        Map sessionMap = (Map)sessionsInThread.get();
        if (sessionMap == null) {
            return;
        }
        sessionMap.remove(sessionId);
    }

    private SessionInMemory createSessionInMemory(Session session) {
        SessionInMemory sessionInMemory = new SessionInMemory();
        sessionInMemory.setCreateTime(new Date());
        sessionInMemory.setSession(session);
        return sessionInMemory;
    }

    private void initSessionsInThread() {
        HashMap sessionMap = (HashMap)sessionsInThread.get();
        if (sessionMap == null) {
            sessionMap = new HashMap();
            sessionsInThread.set(sessionMap);
        }
    }

    private void removeExpiredSessionInMemory() {
        Map sessionMap = (Map)sessionsInThread.get();
        if (sessionMap == null) {
            return;
        }
        Iterator it = sessionMap.keySet().iterator();
        while (it.hasNext()) {
            Serializable sessionId = (Serializable)it.next();
            SessionInMemory sessionInMemory = (SessionInMemory)sessionMap.get(sessionId);
            if (sessionInMemory == null) {
                it.remove();
                continue;
            }
            long liveTime = this.getSessionInMemoryLiveTime(sessionInMemory);
            if (liveTime <= this.sessionInMemoryTimeout) continue;
            it.remove();
        }
        if (sessionMap.size() == 0) {
            sessionsInThread.remove();
        }
    }

    private Session getSessionFromThreadLocal(Serializable sessionId) {
        if (sessionsInThread.get() == null) {
            return null;
        }
        Map sessionMap = (Map)sessionsInThread.get();
        SessionInMemory sessionInMemory = (SessionInMemory)sessionMap.get(sessionId);
        if (sessionInMemory == null) {
            return null;
        }
        logger.debug("read session from memory");
        return sessionInMemory.getSession();
    }

    private long getSessionInMemoryLiveTime(SessionInMemory sessionInMemory) {
        Date now = new Date();
        return now.getTime() - sessionInMemory.getCreateTime().getTime();
    }

    private String getRedisSessionKey(Serializable sessionId) {
        return this.keyPrefix + String.valueOf(sessionId);
    }

    public IRedisManager getRedisManager() {
        return this.redisManager;
    }

    public void setRedisManager(IRedisManager redisManager) {
        this.redisManager = redisManager;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public RedisSerializer getKeySerializer() {
        return this.keySerializer;
    }

    public void setKeySerializer(RedisSerializer keySerializer) {
        this.keySerializer = keySerializer;
    }

    public RedisSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    public void setValueSerializer(RedisSerializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public long getSessionInMemoryTimeout() {
        return this.sessionInMemoryTimeout;
    }

    public void setSessionInMemoryTimeout(long sessionInMemoryTimeout) {
        this.sessionInMemoryTimeout = sessionInMemoryTimeout;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public boolean getSessionInMemoryEnabled() {
        return this.sessionInMemoryEnabled;
    }

    public void setSessionInMemoryEnabled(boolean sessionInMemoryEnabled) {
        this.sessionInMemoryEnabled = sessionInMemoryEnabled;
    }

    public static ThreadLocal getSessionsInThread() {
        return sessionsInThread;
    }
}

