/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro.serializer;

import org.apache.fury.Fury;
import org.apache.fury.config.Language;
import org.crazycake.shiro.exception.SerializationException;
import org.crazycake.shiro.serializer.RedisSerializer;

public class FurySerializer
implements RedisSerializer<Object> {
    private final Fury fury = Fury.builder().withLanguage(Language.JAVA).requireClassRegistration(false).build();

    @Override
    public byte[] serialize(Object object) throws SerializationException {
        if (object == null) {
            return new byte[0];
        }
        try {
            return this.fury.serialize(object);
        }
        catch (Exception e) {
            throw new SerializationException("serialize error, object=" + String.valueOf(object), e);
        }
    }

    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return this.fury.deserialize(bytes);
        }
        catch (Exception e) {
            throw new SerializationException("deserialize error", e);
        }
    }
}

