/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro.cache.redisson;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shiro.lang.io.ResourceUtils;
import org.apache.shiro.lang.util.Initializable;
import org.crazycake.shiro.cache.AbstractWorkAloneRedisManager;
import org.redisson.api.RedissonClient;
import org.redisson.api.options.KeysScanOptions;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.spring.cache.CacheConfig;

public class RedissonRedisManager
extends AbstractWorkAloneRedisManager
implements Initializable {
    private boolean allowNullValues = true;
    private Codec codec = new JsonJacksonCodec();
    private RedissonClient redisson;
    private String configLocation;
    private Map<String, CacheConfig> configMap = new ConcurrentHashMap<String, CacheConfig>();

    private RedissonRedisManager() {
    }

    public RedissonRedisManager(RedissonClient redisson) {
        this(redisson, (String)null, null);
    }

    public RedissonRedisManager(RedissonClient redisson, Map<String, ? extends CacheConfig> config, Codec codec) {
        this.redisson = redisson;
        this.configMap = config;
        if (codec != null) {
            this.codec = codec;
        }
    }

    public RedissonRedisManager(RedissonClient redisson, String configLocation) {
        this(redisson, configLocation, null);
    }

    public RedissonRedisManager(RedissonClient redisson, String configLocation, Codec codec) {
        this.redisson = redisson;
        this.configLocation = configLocation;
        if (codec != null) {
            this.codec = codec;
        }
    }

    protected CacheConfig createDefaultConfig() {
        return new CacheConfig();
    }

    public void init() {
        if (this.configLocation == null) {
            return;
        }
        try {
            this.configMap = CacheConfig.fromJSON((InputStream)ResourceUtils.getInputStreamForPath((String)this.configLocation));
        }
        catch (IOException e) {
            try {
                this.configMap = CacheConfig.fromYAML((InputStream)ResourceUtils.getInputStreamForPath((String)this.configLocation));
            }
            catch (IOException e1) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u7f13\u5b58\u914d\u7f6e\u6587\u4ef6: [" + this.configLocation + "]", e1);
            }
        }
    }

    @Override
    public byte[] get(byte[] key) {
        if (key == null) {
            return null;
        }
        return (byte[])this.getRedisson().getBucket(new String(key, StandardCharsets.UTF_8)).get();
    }

    @Override
    public byte[] set(byte[] key, byte[] value, int expireTime) {
        if (key == null) {
            return null;
        }
        this.getRedisson().getBucket(new String(key, StandardCharsets.UTF_8)).set((Object)value, (long)expireTime, TimeUnit.SECONDS);
        return value;
    }

    @Override
    public void del(byte[] key) {
        if (key == null) {
            return;
        }
        this.getRedisson().getBucket(new String(key, StandardCharsets.UTF_8)).delete();
    }

    @Override
    public Long dbSize(byte[] pattern) {
        KeysScanOptions keysScanOptions = KeysScanOptions.defaults().pattern(new String(pattern, StandardCharsets.UTF_8)).chunkSize(1000);
        Stream keysStream = this.getRedisson().getKeys().getKeysStream(keysScanOptions);
        return keysStream.count();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        KeysScanOptions keysScanOptions = KeysScanOptions.defaults().pattern(new String(pattern, StandardCharsets.UTF_8)).chunkSize(1000);
        Stream keysStream = this.getRedisson().getKeys().getKeysStream(keysScanOptions);
        return keysStream.map(String::getBytes).collect(Collectors.toSet());
    }

    public void setConfig(Map<String, ? extends CacheConfig> config) {
        this.configMap = config;
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public void setRedisson(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }
}

