/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro.cache.lettuce;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.util.List;
import java.util.Objects;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.crazycake.shiro.cache.lettuce.AbstractLettuceRedisManager;
import org.crazycake.shiro.exception.PoolException;

public class LettuceRedisSentinelManager
extends AbstractLettuceRedisManager {
    private static final String DEFAULT_MASTER_NAME = "mymaster";
    private String masterName = "mymaster";
    private List<String> nodes;
    private String sentinelPassword;
    private ReadFrom readFrom = ReadFrom.REPLICA_PREFERRED;
    private volatile GenericObjectPool<StatefulRedisMasterReplicaConnection<byte[], byte[]>> genericObjectPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize() {
        if (this.genericObjectPool != null) return;
        Class<LettuceRedisSentinelManager> clazz = LettuceRedisSentinelManager.class;
        synchronized (LettuceRedisSentinelManager.class) {
            if (this.genericObjectPool != null) return;
            RedisURI redisURI = this.createSentinelRedisURI();
            RedisClient redisClient = RedisClient.create((RedisURI)redisURI);
            redisClient.setOptions(this.getClientOptions());
            StatefulRedisMasterReplicaConnection connect = MasterReplica.connect((RedisClient)redisClient, (RedisCodec)new ByteArrayCodec(), (RedisURI)redisURI);
            connect.setReadFrom(this.readFrom);
            GenericObjectPoolConfig<?> genericObjectPoolConfig = this.getGenericObjectPoolConfig();
            this.genericObjectPool = ConnectionPoolSupport.createGenericObjectPool(() -> connect, genericObjectPoolConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected StatefulRedisMasterReplicaConnection<byte[], byte[]> getStatefulConnection() {
        if (this.genericObjectPool == null) {
            this.initialize();
        }
        try {
            return (StatefulRedisMasterReplicaConnection)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            throw new PoolException("Could not get a resource from the pool", e);
        }
    }

    private RedisURI createSentinelRedisURI() {
        Objects.requireNonNull(this.nodes, "nodes must not be null!");
        RedisURI.Builder builder = RedisURI.builder();
        for (String node : this.nodes) {
            String[] hostAndPort = node.split(":");
            RedisURI.Builder sentinelBuilder = RedisURI.Builder.redis((String)hostAndPort[0], (int)Integer.parseInt(hostAndPort[1]));
            if (this.sentinelPassword != null) {
                sentinelBuilder.withPassword(this.sentinelPassword.toCharArray());
            }
            builder.withSentinel(sentinelBuilder.build());
        }
        String password = this.getPassword();
        if (password != null) {
            builder.withPassword(password.toCharArray());
        }
        return builder.withSentinelMasterId(this.masterName).withDatabase(this.getDatabase()).build();
    }

    public String getMasterName() {
        return this.masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<String> nodes) {
        this.nodes = nodes;
    }

    public String getSentinelPassword() {
        return this.sentinelPassword;
    }

    public void setSentinelPassword(String sentinelPassword) {
        this.sentinelPassword = sentinelPassword;
    }

    public ReadFrom getReadFrom() {
        return this.readFrom;
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.readFrom = readFrom;
    }
}

