/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro.cache.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.support.ConnectionPoolSupport;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.crazycake.shiro.cache.lettuce.AbstractLettuceRedisManager;
import org.crazycake.shiro.exception.PoolException;

public class LettuceRedisManager
extends AbstractLettuceRedisManager {
    private String host = "localhost";
    private int port = 6379;
    private volatile GenericObjectPool<StatefulRedisConnection<byte[], byte[]>> genericObjectPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize() {
        if (this.genericObjectPool != null) return;
        Class<LettuceRedisManager> clazz = LettuceRedisManager.class;
        synchronized (LettuceRedisManager.class) {
            if (this.genericObjectPool != null) return;
            RedisClient redisClient = RedisClient.create((RedisURI)this.createRedisURI());
            redisClient.setOptions(this.getClientOptions());
            GenericObjectPoolConfig<?> genericObjectPoolConfig = this.getGenericObjectPoolConfig();
            this.genericObjectPool = ConnectionPoolSupport.createGenericObjectPool(() -> redisClient.connect((RedisCodec)new ByteArrayCodec()), genericObjectPoolConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private RedisURI createRedisURI() {
        RedisURI.Builder builder = RedisURI.builder().withHost(this.getHost()).withPort(this.getPort()).withDatabase(this.getDatabase()).withTimeout(this.getTimeout());
        String password = this.getPassword();
        if (password != null) {
            builder.withPassword(password.toCharArray());
        }
        return builder.build();
    }

    protected StatefulRedisConnection<byte[], byte[]> getStatefulConnection() {
        if (this.genericObjectPool == null) {
            this.initialize();
        }
        try {
            return (StatefulRedisConnection)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            throw new PoolException("Could not get a resource from the pool", e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

