/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro.cache.lettuce;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.SetArgs;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import io.lettuce.core.cluster.models.partitions.ClusterPartitionParser;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.crazycake.shiro.cache.IRedisManager;
import org.crazycake.shiro.exception.PoolException;

public class LettuceRedisClusterManager
implements IRedisManager {
    private List<String> nodes;
    private static final int DEFAULT_COUNT = 100;
    private Duration timeout = RedisURI.DEFAULT_TIMEOUT_DURATION;
    private int database = 0;
    private String password;
    private boolean isAsync = true;
    private int count = 100;
    private GenericObjectPoolConfig<StatefulRedisClusterConnection<byte[], byte[]>> genericObjectPoolConfig = new GenericObjectPoolConfig();
    private volatile GenericObjectPool<StatefulRedisClusterConnection<byte[], byte[]>> genericObjectPool;
    private ClusterClientOptions clusterClientOptions = ClusterClientOptions.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize() {
        if (this.genericObjectPool != null) return;
        Class<LettuceRedisClusterManager> clazz = LettuceRedisClusterManager.class;
        synchronized (LettuceRedisClusterManager.class) {
            if (this.genericObjectPool != null) return;
            RedisClusterClient redisClusterClient = RedisClusterClient.create(this.getClusterRedisURI());
            redisClusterClient.setOptions(this.clusterClientOptions);
            StatefulRedisClusterConnection connect = redisClusterClient.connect((RedisCodec)new ByteArrayCodec());
            this.genericObjectPool = ConnectionPoolSupport.createGenericObjectPool(() -> connect, this.genericObjectPoolConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private StatefulRedisClusterConnection<byte[], byte[]> getStatefulConnection() {
        if (this.genericObjectPool == null) {
            this.initialize();
        }
        try {
            return (StatefulRedisClusterConnection)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            throw new PoolException("Could not get a resource from the pool", e);
        }
    }

    private List<RedisURI> getClusterRedisURI() {
        Objects.requireNonNull(this.nodes, "nodes must not be null!");
        return this.nodes.stream().map(node -> {
            String[] hostAndPort = node.split(":");
            RedisURI.Builder builder = RedisURI.builder().withHost(hostAndPort[0]).withPort(Integer.parseInt(hostAndPort[1])).withDatabase(this.database).withTimeout(this.timeout);
            if (this.password != null) {
                builder.withPassword(this.password.toCharArray());
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    @Override
    public byte[] get(byte[] key) {
        if (key == null) {
            return null;
        }
        byte[] value = null;
        try (StatefulRedisClusterConnection<byte[], byte[]> connection = this.getStatefulConnection();){
            if (this.isAsync) {
                RedisAdvancedClusterAsyncCommands async = connection.async();
                value = (byte[])LettuceFutures.awaitOrCancel((RedisFuture)async.get((Object)key), (long)this.timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
            } else {
                RedisAdvancedClusterCommands sync = connection.sync();
                value = (byte[])sync.get((Object)key);
            }
        }
        return value;
    }

    @Override
    public byte[] set(byte[] key, byte[] value, int expire) {
        if (key == null) {
            return null;
        }
        try (StatefulRedisClusterConnection<byte[], byte[]> connection = this.getStatefulConnection();){
            if (this.isAsync) {
                RedisAdvancedClusterAsyncCommands async = connection.async();
                if (expire > 0) {
                    async.set((Object)key, (Object)value, SetArgs.Builder.ex((long)expire));
                } else {
                    async.set((Object)key, (Object)value);
                }
            } else {
                RedisAdvancedClusterCommands sync = connection.sync();
                if (expire > 0) {
                    sync.set((Object)key, (Object)value, SetArgs.Builder.ex((long)expire));
                } else {
                    sync.set((Object)key, (Object)value);
                }
            }
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        try (StatefulRedisClusterConnection<byte[], byte[]> connection = this.getStatefulConnection();){
            if (this.isAsync) {
                RedisAdvancedClusterAsyncCommands async = connection.async();
                async.del((Object[])new byte[][]{key});
            } else {
                RedisAdvancedClusterCommands sync = connection.sync();
                sync.del((Object[])new byte[][]{key});
            }
        }
    }

    @Override
    public Long dbSize(byte[] pattern) {
        AtomicLong dbSize = new AtomicLong(0L);
        try (StatefulRedisClusterConnection<byte[], byte[]> connection = this.getStatefulConnection();){
            if (this.isAsync) {
                RedisAdvancedClusterAsyncCommands async = connection.async();
                Partitions parse = ClusterPartitionParser.parse((String)((String)LettuceFutures.awaitOrCancel((RedisFuture)async.clusterNodes(), (long)this.timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS)));
                parse.forEach(redisClusterNode -> {
                    RedisClusterAsyncCommands clusterAsyncCommands = async.getConnection(redisClusterNode.getNodeId());
                    KeyScanCursor scanCursor = new KeyScanCursor();
                    scanCursor.setCursor(ScanCursor.INITIAL.getCursor());
                    ScanArgs scanArgs = ScanArgs.Builder.matches((byte[])pattern).limit((long)this.count);
                    while (!scanCursor.isFinished()) {
                        scanCursor = (KeyScanCursor)LettuceFutures.awaitOrCancel((RedisFuture)clusterAsyncCommands.scan((ScanCursor)scanCursor, scanArgs), (long)this.timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
                        dbSize.addAndGet(scanCursor.getKeys().size());
                    }
                });
            } else {
                RedisAdvancedClusterCommands sync = connection.sync();
                Partitions parse = ClusterPartitionParser.parse((String)sync.clusterNodes());
                parse.forEach(redisClusterNode -> {
                    RedisClusterCommands clusterCommands = sync.getConnection(redisClusterNode.getNodeId());
                    KeyScanCursor scanCursor = new KeyScanCursor();
                    scanCursor.setCursor(ScanCursor.INITIAL.getCursor());
                    ScanArgs scanArgs = ScanArgs.Builder.matches((byte[])pattern).limit((long)this.count);
                    while (!scanCursor.isFinished()) {
                        scanCursor = clusterCommands.scan((ScanCursor)scanCursor, scanArgs);
                        dbSize.addAndGet(scanCursor.getKeys().size());
                    }
                });
            }
        }
        return dbSize.get();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        try (StatefulRedisClusterConnection<byte[], byte[]> connection = this.getStatefulConnection();){
            if (this.isAsync) {
                RedisAdvancedClusterAsyncCommands async = connection.async();
                Partitions parse = ClusterPartitionParser.parse((String)((String)LettuceFutures.awaitOrCancel((RedisFuture)async.clusterNodes(), (long)this.timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS)));
                parse.forEach(redisClusterNode -> {
                    RedisClusterAsyncCommands clusterAsyncCommands = async.getConnection(redisClusterNode.getNodeId());
                    KeyScanCursor scanCursor = new KeyScanCursor();
                    scanCursor.setCursor(ScanCursor.INITIAL.getCursor());
                    ScanArgs scanArgs = ScanArgs.Builder.matches((byte[])pattern).limit((long)this.count);
                    while (!scanCursor.isFinished()) {
                        scanCursor = (KeyScanCursor)LettuceFutures.awaitOrCancel((RedisFuture)clusterAsyncCommands.scan((ScanCursor)scanCursor, scanArgs), (long)this.timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
                        keys.addAll(scanCursor.getKeys());
                    }
                });
            } else {
                RedisAdvancedClusterCommands sync = connection.sync();
                Partitions parse = ClusterPartitionParser.parse((String)sync.clusterNodes());
                parse.forEach(redisClusterNode -> {
                    RedisClusterCommands clusterCommands = sync.getConnection(redisClusterNode.getNodeId());
                    KeyScanCursor scanCursor = new KeyScanCursor();
                    scanCursor.setCursor(ScanCursor.INITIAL.getCursor());
                    ScanArgs scanArgs = ScanArgs.Builder.matches((byte[])pattern).limit((long)this.count);
                    while (!scanCursor.isFinished()) {
                        scanCursor = clusterCommands.scan((ScanCursor)scanCursor, scanArgs);
                        keys.addAll(scanCursor.getKeys());
                    }
                });
            }
        }
        return keys;
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<String> nodes) {
        this.nodes = nodes;
    }

    public ClusterClientOptions getClusterClientOptions() {
        return this.clusterClientOptions;
    }

    public void setClusterClientOptions(ClusterClientOptions clusterClientOptions) {
        this.clusterClientOptions = clusterClientOptions;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setIsAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public GenericObjectPoolConfig<StatefulRedisClusterConnection<byte[], byte[]>> getGenericObjectPoolConfig() {
        return this.genericObjectPoolConfig;
    }

    public void setGenericObjectPoolConfig(GenericObjectPoolConfig<StatefulRedisClusterConnection<byte[], byte[]>> genericObjectPoolConfig) {
        this.genericObjectPoolConfig = genericObjectPoolConfig;
    }

    public GenericObjectPool<StatefulRedisClusterConnection<byte[], byte[]>> getGenericObjectPool() {
        return this.genericObjectPool;
    }

    public void setGenericObjectPool(GenericObjectPool<StatefulRedisClusterConnection<byte[], byte[]>> genericObjectPool) {
        this.genericObjectPool = genericObjectPool;
    }
}

