/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro.cache.lettuce;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.crazycake.shiro.cache.AbstractWorkAloneRedisManager;

public abstract class AbstractLettuceRedisManager
extends AbstractWorkAloneRedisManager {
    private static final int DEFAULT_COUNT = 100;
    private Duration timeout = RedisURI.DEFAULT_TIMEOUT_DURATION;
    private int database = 0;
    private String password;
    private boolean isAsync = true;
    private int count = 100;
    private ClientOptions clientOptions = ClientOptions.create();
    private GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();

    protected abstract StatefulRedisConnection getStatefulConnection();

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setIsAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public GenericObjectPoolConfig<?> getGenericObjectPoolConfig() {
        return this.genericObjectPoolConfig;
    }

    public void setGenericObjectPoolConfig(GenericObjectPoolConfig<?> genericObjectPoolConfig) {
        this.genericObjectPoolConfig = genericObjectPoolConfig;
    }

    @Override
    public byte[] get(byte[] key) {
        if (key == null) {
            return null;
        }
        byte[] value = null;
        try (StatefulRedisConnection connect = this.getStatefulConnection();){
            if (this.isAsync) {
                RedisAsyncCommands async = connect.async();
                RedisFuture redisFuture = async.get((Object)key);
                value = (byte[])LettuceFutures.awaitOrCancel((RedisFuture)redisFuture, (long)this.timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
            } else {
                RedisCommands sync = connect.sync();
                value = (byte[])sync.get((Object)key);
            }
        }
        return value;
    }

    @Override
    public byte[] set(byte[] key, byte[] value, int expire) {
        if (key == null) {
            return null;
        }
        try (StatefulRedisConnection connect = this.getStatefulConnection();){
            if (this.isAsync) {
                RedisAsyncCommands async = connect.async();
                if (expire > 0) {
                    async.set((Object)key, (Object)value, SetArgs.Builder.ex((long)expire));
                } else {
                    async.set((Object)key, (Object)value);
                }
            } else {
                RedisCommands sync = connect.sync();
                if (expire > 0) {
                    sync.set((Object)key, (Object)value, SetArgs.Builder.ex((long)expire));
                } else {
                    sync.set((Object)key, (Object)value);
                }
            }
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        try (StatefulRedisConnection connect = this.getStatefulConnection();){
            if (this.isAsync) {
                RedisAsyncCommands async = connect.async();
                async.del((Object[])new byte[][]{key});
            } else {
                RedisCommands sync = connect.sync();
                sync.del((Object[])new byte[][]{key});
            }
        }
    }

    @Override
    public Long dbSize(byte[] pattern) {
        long dbSize = 0L;
        KeyScanCursor<byte[]> scanCursor = new KeyScanCursor<byte[]>();
        scanCursor.setCursor(ScanCursor.INITIAL.getCursor());
        ScanArgs scanArgs = ScanArgs.Builder.matches((byte[])pattern).limit((long)this.count);
        try (StatefulRedisConnection connect = this.getStatefulConnection();){
            while (!scanCursor.isFinished()) {
                scanCursor = this.getKeyScanCursor((StatefulRedisConnection<byte[], byte[]>)connect, scanCursor, scanArgs);
                dbSize += (long)scanCursor.getKeys().size();
            }
        }
        return dbSize;
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        KeyScanCursor<byte[]> scanCursor = new KeyScanCursor<byte[]>();
        scanCursor.setCursor(ScanCursor.INITIAL.getCursor());
        ScanArgs scanArgs = ScanArgs.Builder.matches((byte[])pattern).limit((long)this.count);
        try (StatefulRedisConnection connect = this.getStatefulConnection();){
            while (!scanCursor.isFinished()) {
                scanCursor = this.getKeyScanCursor((StatefulRedisConnection<byte[], byte[]>)connect, scanCursor, scanArgs);
                keys.addAll(scanCursor.getKeys());
            }
        }
        return keys;
    }

    private KeyScanCursor<byte[]> getKeyScanCursor(StatefulRedisConnection<byte[], byte[]> connect, KeyScanCursor<byte[]> scanCursor, ScanArgs scanArgs) {
        if (this.isAsync) {
            RedisAsyncCommands async = connect.async();
            scanCursor = (KeyScanCursor)LettuceFutures.awaitOrCancel((RedisFuture)async.scan(scanCursor, scanArgs), (long)this.timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
        } else {
            RedisCommands sync = connect.sync();
            scanCursor = sync.scan(scanCursor, scanArgs);
        }
        return scanCursor;
    }
}

