/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro.cache.jedis;

import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.crazycake.shiro.cache.jedis.AbstractJedisRedisManager;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;

public class JedisRedisSentinelManager
extends AbstractJedisRedisManager {
    private static final String DEFAULT_HOST = "127.0.0.1:26379,127.0.0.1:26380,127.0.0.1:26381";
    private String host = "127.0.0.1:26379,127.0.0.1:26380,127.0.0.1:26381";
    private static final String DEFAULT_MASTER_NAME = "mymaster";
    private String masterName = "mymaster";
    private int timeout = 2000;
    private int soTimeout = 2000;
    private String password;
    private int database = 0;
    private volatile JedisSentinelPool jedisPool;

    @Override
    protected Jedis getJedis() {
        if (this.jedisPool == null) {
            this.init();
        }
        return this.jedisPool.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.jedisPool != null) return;
        Class<JedisRedisSentinelManager> clazz = JedisRedisSentinelManager.class;
        synchronized (JedisRedisSentinelManager.class) {
            if (this.jedisPool != null) return;
            String[] sentinelHosts = this.host.split(",\\s*");
            HashSet sentinels = new HashSet();
            Collections.addAll(sentinels, sentinelHosts);
            this.jedisPool = new JedisSentinelPool(this.masterName, sentinels, (GenericObjectPoolConfig)this.getJedisPoolConfig(), this.timeout, this.soTimeout, this.password, this.database);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public JedisSentinelPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisSentinelPool jedisPool) {
        this.jedisPool = jedisPool;
    }
}

