/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.crazycake.shiro.IRedisManager;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class RedisClusterManager
implements IRedisManager {
    private static final int DEFAULT_COUNT = 100;
    private static final int DEFAULT_MAX_ATTEMPTS = 3;
    private static final String DEFAULT_HOST = "127.0.0.1:7000,127.0.0.1:7001,127.0.0.1:7002";
    private String host = "127.0.0.1:7000,127.0.0.1:7001,127.0.0.1:7002";
    private int timeout = 2000;
    private int soTimeout = 2000;
    private String password;
    private int database = 0;
    private int count = 100;
    private int maxAttempts = 3;
    private JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
    private volatile JedisCluster jedisCluster = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        RedisClusterManager redisClusterManager = this;
        synchronized (redisClusterManager) {
            if (this.jedisCluster == null) {
                this.jedisCluster = new JedisCluster(this.getHostAndPortSet(), this.timeout, this.soTimeout, this.maxAttempts, this.password, (GenericObjectPoolConfig)this.getJedisPoolConfig());
            }
        }
    }

    private Set<HostAndPort> getHostAndPortSet() {
        String[] hostAndPortArr = this.host.split(",");
        HashSet<HostAndPort> hostAndPorts = new HashSet<HostAndPort>();
        for (String hostAndPortStr : hostAndPortArr) {
            String[] hostAndPort = hostAndPortStr.split(":");
            hostAndPorts.add(new HostAndPort(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
        }
        return hostAndPorts;
    }

    protected JedisCluster getJedisCluster() {
        if (this.jedisCluster == null) {
            this.init();
        }
        return this.jedisCluster;
    }

    @Override
    public byte[] get(byte[] key) {
        if (key == null) {
            return null;
        }
        return this.getJedisCluster().get(key);
    }

    @Override
    public byte[] set(byte[] key, byte[] value, int expireTime) {
        if (key == null) {
            return null;
        }
        this.getJedisCluster().set(key, value);
        if (expireTime >= 0) {
            this.getJedisCluster().expire(key, expireTime);
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        if (key == null) {
            return;
        }
        this.getJedisCluster().del(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long dbSize() {
        Long dbSize = 0L;
        Map clusterNodes = this.getJedisCluster().getClusterNodes();
        for (String k : clusterNodes.keySet()) {
            JedisPool jp = (JedisPool)clusterNodes.get(k);
            Jedis connection = jp.getResource();
            try {
                dbSize = dbSize + connection.dbSize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                connection.close();
            }
        }
        return dbSize;
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        Map clusterNodes = this.getJedisCluster().getClusterNodes();
        for (Map.Entry node : clusterNodes.entrySet()) {
            Set<byte[]> nodeKeys = this.getKeysFromClusterNode((JedisPool)node.getValue(), pattern);
            if (nodeKeys == null || nodeKeys.size() == 0) continue;
            keys.addAll(nodeKeys);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<byte[]> getKeysFromClusterNode(JedisPool jedisPool, byte[] pattern) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        Jedis jedis = jedisPool.getResource();
        try {
            ScanResult scanResult;
            ScanParams params = new ScanParams();
            params.count(Integer.valueOf(this.count));
            params.match(pattern);
            byte[] cursor = ScanParams.SCAN_POINTER_START_BINARY;
            do {
                scanResult = jedis.scan(cursor, params);
                keys.addAll(scanResult.getResult());
                cursor = scanResult.getCursorAsBytes();
            } while (scanResult.getStringCursor().compareTo(ScanParams.SCAN_POINTER_START) > 0);
        }
        finally {
            jedis.close();
        }
        return keys;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    public JedisPoolConfig getJedisPoolConfig() {
        return this.jedisPoolConfig;
    }

    public void setJedisPoolConfig(JedisPoolConfig jedisPoolConfig) {
        this.jedisPoolConfig = jedisPoolConfig;
    }
}

