/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.crazycake.shiro.AuthCachePrincipal;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.exception.PrincipalInstanceException;
import org.crazycake.shiro.exception.SerializationException;
import org.crazycake.shiro.serializer.ObjectSerializer;
import org.crazycake.shiro.serializer.RedisSerializer;
import org.crazycake.shiro.serializer.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCache<K, V>
implements Cache<K, V> {
    private static Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private RedisSerializer keySerializer = new StringSerializer();
    private RedisSerializer valueSerializer = new ObjectSerializer();
    private IRedisManager redisManager;
    private String keyPrefix = "";
    private int expire = 0;

    public RedisCache(IRedisManager redisManager, RedisSerializer keySerializer, RedisSerializer valueSerializer, String prefix, int expire) {
        if (redisManager == null) {
            throw new IllegalArgumentException("redisManager cannot be null.");
        }
        this.redisManager = redisManager;
        if (keySerializer == null) {
            throw new IllegalArgumentException("keySerializer cannot be null.");
        }
        this.keySerializer = keySerializer;
        if (valueSerializer == null) {
            throw new IllegalArgumentException("valueSerializer cannot be null.");
        }
        this.valueSerializer = valueSerializer;
        if (prefix != null && !"".equals(prefix)) {
            this.keyPrefix = prefix;
        }
        if (expire != -1) {
            this.expire = expire;
        }
    }

    public V get(K key) throws CacheException {
        logger.debug("get key [" + key + "]");
        if (key == null) {
            return null;
        }
        try {
            Object redisCacheKey = this.getRedisCacheKey(key);
            byte[] rawValue = this.redisManager.get(this.keySerializer.serialize(redisCacheKey));
            if (rawValue == null) {
                return null;
            }
            Object value = this.valueSerializer.deserialize(rawValue);
            return (V)value;
        }
        catch (SerializationException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public V put(K key, V value) throws CacheException {
        logger.debug("put key [" + key + "]");
        if (key == null) {
            logger.warn("Saving a null key is meaningless, return value directly without call Redis.");
            return value;
        }
        try {
            Object redisCacheKey = this.getRedisCacheKey(key);
            this.redisManager.set(this.keySerializer.serialize(redisCacheKey), value != null ? this.valueSerializer.serialize(value) : null, this.expire);
            return value;
        }
        catch (SerializationException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public V remove(K key) throws CacheException {
        logger.debug("remove key [" + key + "]");
        if (key == null) {
            return null;
        }
        try {
            Object redisCacheKey = this.getRedisCacheKey(key);
            byte[] rawValue = this.redisManager.get(this.keySerializer.serialize(redisCacheKey));
            Object previous = this.valueSerializer.deserialize(rawValue);
            this.redisManager.del(this.keySerializer.serialize(redisCacheKey));
            return (V)previous;
        }
        catch (SerializationException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private Object getRedisCacheKey(K key) {
        if (key == null) {
            return null;
        }
        Object redisKey = key;
        if (this.keySerializer instanceof StringSerializer) {
            redisKey = this.getStringRedisKey(key);
        }
        if (redisKey instanceof String) {
            return this.keyPrefix + (String)redisKey;
        }
        return redisKey;
    }

    private Object getStringRedisKey(K key) {
        Object redisKey = key instanceof PrincipalCollection ? this.getRedisKeyFromPrincipalCollection((PrincipalCollection)key) : key.toString();
        return redisKey;
    }

    private Object getRedisKeyFromPrincipalCollection(PrincipalCollection key) {
        PrincipalCollection principalCollection = key;
        if (!(principalCollection.getPrimaryPrincipal() instanceof AuthCachePrincipal)) {
            throw new PrincipalInstanceException();
        }
        AuthCachePrincipal principal = (AuthCachePrincipal)principalCollection.getPrimaryPrincipal();
        String redisKey = principal.getAuthCacheKey();
        return redisKey;
    }

    public void clear() throws CacheException {
        logger.debug("clear cache");
        Set<byte[]> keys = null;
        try {
            keys = this.redisManager.keys(this.keySerializer.serialize(this.keyPrefix + "*"));
        }
        catch (SerializationException e) {
            logger.error("get keys error", (Throwable)e);
        }
        if (keys == null || keys.size() == 0) {
            return;
        }
        for (byte[] key : keys) {
            this.redisManager.del(key);
        }
    }

    public int size() {
        Long longSize = new Long(this.redisManager.dbSize());
        return longSize.intValue();
    }

    public Set<K> keys() {
        Set<byte[]> keys = null;
        try {
            keys = this.redisManager.keys(this.keySerializer.serialize(this.keyPrefix + "*"));
        }
        catch (SerializationException e) {
            logger.error("get keys error", (Throwable)e);
            return Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptySet();
        }
        HashSet convertedKeys = new HashSet();
        for (byte[] key : keys) {
            try {
                convertedKeys.add(this.keySerializer.deserialize(key));
            }
            catch (SerializationException e) {
                logger.error("deserialize keys error", (Throwable)e);
            }
        }
        return convertedKeys;
    }

    public Collection<V> values() {
        Set<byte[]> keys = null;
        try {
            keys = this.redisManager.keys(this.keySerializer.serialize(this.keyPrefix + "*"));
        }
        catch (SerializationException e) {
            logger.error("get values error", (Throwable)e);
            return Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptySet();
        }
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (byte[] key : keys) {
            Object value = null;
            try {
                value = this.valueSerializer.deserialize(this.redisManager.get(key));
            }
            catch (SerializationException e) {
                logger.error("deserialize values= error", (Throwable)e);
            }
            if (value == null) continue;
            values.add(value);
        }
        return Collections.unmodifiableList(values);
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }
}

