/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.util.List;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.crazycake.shiro.CacheManagerProperties;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisClusterManager;
import org.crazycake.shiro.RedisManager;
import org.crazycake.shiro.RedisManagerProperties;
import org.crazycake.shiro.RedisSentinelManager;
import org.crazycake.shiro.RedisSessionDAO;
import org.crazycake.shiro.RedisSessionDAOProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.util.StringUtils;

@Configuration
@PropertySource(value={"classpath:shiro-redis.properties"})
@EnableConfigurationProperties(value={RedisManagerProperties.class, CacheManagerProperties.class, RedisSessionDAOProperties.class})
@ConditionalOnProperty(name={"shiro-redis.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ShiroWebAutoConfiguration.class})
public class ShiroRedisAutoConfiguration {
    @Autowired
    private RedisManagerProperties redisManagerProperties;
    @Autowired
    private CacheManagerProperties cacheManagerProperties;
    @Autowired
    private RedisSessionDAOProperties redisSessionDAOProperties;

    @Bean
    @ConditionalOnMissingBean
    public IRedisManager redisManager() {
        IRedisManager redisManager = null;
        if ("standalone".equals(this.redisManagerProperties.getDeployMode())) {
            redisManager = this.createStandaloneRedisManager();
        }
        if ("sentinel".equals(this.redisManagerProperties.getDeployMode())) {
            redisManager = this.createRedisSentinelManager();
        }
        if ("cluster".equals(this.redisManagerProperties.getDeployMode())) {
            redisManager = this.createRedisClusterManager();
        }
        return redisManager;
    }

    private IRedisManager createRedisClusterManager() {
        RedisClusterManager clusterManager = new RedisClusterManager();
        if (!StringUtils.isEmpty((Object)this.redisManagerProperties.getHost())) {
            clusterManager.setHost(this.redisManagerProperties.getHost());
        }
        if (this.redisManagerProperties.getTimeout() != null) {
            clusterManager.setTimeout(this.redisManagerProperties.getTimeout().intValue());
        }
        if (this.redisManagerProperties.getSoTimeout() != null) {
            clusterManager.setSoTimeout(this.redisManagerProperties.getSoTimeout().intValue());
        }
        if (this.redisManagerProperties.getMaxAttempts() != null) {
            clusterManager.setMaxAttempts(this.redisManagerProperties.getMaxAttempts().intValue());
        }
        if (!StringUtils.isEmpty((Object)this.redisManagerProperties.getPassword())) {
            clusterManager.setPassword(this.redisManagerProperties.getPassword());
        }
        if (this.redisManagerProperties.getDatabase() != null) {
            clusterManager.setDatabase(this.redisManagerProperties.getDatabase().intValue());
        }
        if (this.redisManagerProperties.getCount() != null) {
            clusterManager.setCount(this.redisManagerProperties.getCount().intValue());
        }
        RedisClusterManager redisManager = clusterManager;
        return redisManager;
    }

    private IRedisManager createRedisSentinelManager() {
        RedisSentinelManager sentinelManager = new RedisSentinelManager();
        if (!StringUtils.isEmpty((Object)this.redisManagerProperties.getHost())) {
            sentinelManager.setHost(this.redisManagerProperties.getHost());
        }
        if (this.redisManagerProperties.getTimeout() != null) {
            sentinelManager.setTimeout(this.redisManagerProperties.getTimeout().intValue());
        }
        if (!StringUtils.isEmpty((Object)this.redisManagerProperties.getMasterName())) {
            sentinelManager.setMasterName(this.redisManagerProperties.getMasterName());
        }
        if (this.redisManagerProperties.getSoTimeout() != null) {
            sentinelManager.setSoTimeout(this.redisManagerProperties.getSoTimeout().intValue());
        }
        if (!StringUtils.isEmpty((Object)this.redisManagerProperties.getPassword())) {
            sentinelManager.setPassword(this.redisManagerProperties.getPassword());
        }
        if (this.redisManagerProperties.getDatabase() != null) {
            sentinelManager.setDatabase(this.redisManagerProperties.getDatabase().intValue());
        }
        if (this.redisManagerProperties.getCount() != null) {
            sentinelManager.setCount(this.redisManagerProperties.getCount().intValue());
        }
        RedisSentinelManager redisManager = sentinelManager;
        return redisManager;
    }

    private IRedisManager createStandaloneRedisManager() {
        RedisManager standaloneManager = new RedisManager();
        if (!StringUtils.isEmpty((Object)this.redisManagerProperties.getHost())) {
            standaloneManager.setHost(this.redisManagerProperties.getHost());
        }
        if (this.redisManagerProperties.getTimeout() != null) {
            standaloneManager.setTimeout(this.redisManagerProperties.getTimeout().intValue());
        }
        if (!StringUtils.isEmpty((Object)this.redisManagerProperties.getPassword())) {
            standaloneManager.setPassword(this.redisManagerProperties.getPassword());
        }
        if (this.redisManagerProperties.getDatabase() != null) {
            standaloneManager.setDatabase(this.redisManagerProperties.getDatabase().intValue());
        }
        if (this.redisManagerProperties.getCount() != null) {
            standaloneManager.setCount(this.redisManagerProperties.getCount().intValue());
        }
        RedisManager redisManager = standaloneManager;
        return redisManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisSessionDAO redisSessionDAO(IRedisManager redisManager) {
        RedisSessionDAO redisSessionDAO = new RedisSessionDAO();
        redisSessionDAO.setRedisManager(redisManager);
        if (this.redisSessionDAOProperties.getExpire() != null) {
            redisSessionDAO.setExpire(this.redisSessionDAOProperties.getExpire().intValue());
        }
        if (!StringUtils.isEmpty((Object)this.redisSessionDAOProperties.getKeyPrefix())) {
            redisSessionDAO.setKeyPrefix(this.redisSessionDAOProperties.getKeyPrefix());
        }
        if (this.redisSessionDAOProperties.getSessionInMemoryTimeout() != null) {
            redisSessionDAO.setSessionInMemoryTimeout(this.redisSessionDAOProperties.getSessionInMemoryTimeout().longValue());
        }
        return redisSessionDAO;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisCacheManager redisCacheManager(IRedisManager redisManager) {
        RedisCacheManager cacheManager = new RedisCacheManager();
        cacheManager.setRedisManager(redisManager);
        if (!StringUtils.isEmpty((Object)this.cacheManagerProperties.getPrincipalIdFieldName())) {
            cacheManager.setPrincipalIdFieldName(this.cacheManagerProperties.getPrincipalIdFieldName());
        }
        if (this.cacheManagerProperties.getExpire() != null) {
            cacheManager.setExpire(this.cacheManagerProperties.getExpire().intValue());
        }
        if (!StringUtils.isEmpty((Object)this.cacheManagerProperties.getKeyPrefix())) {
            cacheManager.setKeyPrefix(this.cacheManagerProperties.getKeyPrefix());
        }
        return cacheManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionManager sessionManager(RedisSessionDAO redisSessionDAO) {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionDAO((SessionDAO)redisSessionDAO);
        return sessionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionsSecurityManager securityManager(List<Realm> realms, SessionManager sessionManager, RedisCacheManager redisCacheManager) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager(realms);
        securityManager.setSessionManager(sessionManager);
        securityManager.setCacheManager((CacheManager)redisCacheManager);
        return securityManager;
    }
}

