/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.store;

import java.io.IOException;
import java.util.ArrayList;
import net.jini.core.transaction.TransactionException;
import org.apache.lucene.store.IndexOutput;
import org.compass.needle.gigaspaces.store.FileBucketEntry;
import org.compass.needle.gigaspaces.store.FileEntry;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectory;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectoryException;

public class FlushOnCloseGigaSpaceIndexOutput
extends IndexOutput {
    private GigaSpaceDirectory dir;
    private final ArrayList<byte[]> buckets = new ArrayList();
    private final int bucketSize;
    private final String fileName;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;
    private boolean open;
    private long length;

    public FlushOnCloseGigaSpaceIndexOutput(GigaSpaceDirectory dir, String fileName) throws IOException {
        this.dir = dir;
        this.fileName = fileName;
        this.bucketSize = dir.getBucketSize();
        this.open = true;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition == this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        this.currentBuffer[this.bufferPosition++] = b;
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int bytesToCopy = len < (remainInBuffer = this.currentBuffer.length - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(b, offset, this.currentBuffer, this.bufferPosition, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    public void flush() throws IOException {
        this.setFileLength();
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.flush();
        Object[] entries = new Object[this.buckets.size() + 1];
        for (int i = 0; i < this.buckets.size(); ++i) {
            if (i == this.buckets.size() - 1) {
                byte[] buff = new byte[(int)(this.length - (long)(this.bucketSize * i))];
                System.arraycopy(this.buckets.get(i), 0, buff, 0, buff.length);
                entries[i] = new FileBucketEntry(this.dir.getIndexName(), this.fileName, i, buff);
                continue;
            }
            entries[i] = new FileBucketEntry(this.dir.getIndexName(), this.fileName, i, this.buckets.get(i));
        }
        entries[this.buckets.size()] = new FileEntry(this.dir.getIndexName(), this.fileName, this.length);
        try {
            this.dir.getSpace().writeMultiple(entries, null, Long.MAX_VALUE);
        }
        catch (TransactionException e) {
            throw new GigaSpaceDirectoryException(this.dir.getIndexName(), this.fileName, "Failed to write to space", (Exception)((Object)e));
        }
        this.currentBuffer = null;
    }

    public long length() {
        return this.length;
    }

    public void seek(long pos) throws IOException {
        this.setFileLength();
        if (pos < this.bufferStart || pos >= this.bufferStart + (long)this.bufferLength) {
            this.currentBufferIndex = (int)(pos / (long)this.bucketSize);
            this.switchCurrentBuffer();
        }
        this.bufferPosition = (int)(pos % (long)this.bucketSize);
    }

    private void switchCurrentBuffer() throws IOException {
        if (this.currentBufferIndex == this.buckets.size()) {
            this.currentBuffer = new byte[this.bucketSize];
            this.buckets.add(this.currentBuffer);
        } else {
            this.currentBuffer = this.buckets.get(this.currentBufferIndex);
        }
        this.bufferPosition = 0;
        this.bufferStart = (long)this.bucketSize * (long)this.currentBufferIndex;
        this.bufferLength = this.currentBuffer.length;
    }

    private void setFileLength() {
        long pointer = this.bufferStart + (long)this.bufferPosition;
        if (pointer > this.length) {
            this.length = pointer;
        }
    }
}

