/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.extractor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.compass.core.CompassException;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.extractor.NativeJpaExtractor;

public class GlassfishNativeHibernateJpaExtractor
implements NativeJpaExtractor {
    private static final String EMF_WRAPPER_CLASS = "com.sun.enterprise.util.EntityManagerFactoryWrapper";
    private static final String EM_WRAPPER_CLASS = "com.sun.enterprise.util.EntityManagerWrapper";
    private Class emfWrapperClass;
    private Class emWrapperClass;
    private Method emfGetDelegateMethod;
    private Method emGetDelegateMethod;

    public GlassfishNativeHibernateJpaExtractor() {
        try {
            this.emfWrapperClass = GlassfishNativeHibernateJpaExtractor.class.getClassLoader().loadClass(EMF_WRAPPER_CLASS);
            this.emfGetDelegateMethod = this.emfWrapperClass.getDeclaredMethod("getDelegate", new Class[0]);
            this.emfGetDelegateMethod.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            throw new CompassException("Failed to find Glassfish EMF wrapper class [com.sun.enterprise.util.EntityManagerFactoryWrapper]");
        }
        catch (NoSuchMethodException e) {
            throw new CompassException("Failed to find Glassfish getDelegate method within wrapper class [com.sun.enterprise.util.EntityManagerFactoryWrapper]");
        }
        try {
            this.emWrapperClass = GlassfishNativeHibernateJpaExtractor.class.getClassLoader().loadClass(EM_WRAPPER_CLASS);
            this.emGetDelegateMethod = this.emWrapperClass.getDeclaredMethod("getDelegate", new Class[0]);
            this.emGetDelegateMethod.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            throw new CompassException("Failed to find Glassfish EM wrapper class [com.sun.enterprise.util.EntityManagerWrapper]");
        }
        catch (NoSuchMethodException e) {
            throw new CompassException("Failed to find Glassfish getDelegate method within wrapper class [com.sun.enterprise.util.EntityManagerWrapper]");
        }
    }

    public EntityManagerFactory extractNative(EntityManagerFactory entityManagerFactory) throws JpaGpsDeviceException {
        if (this.emfWrapperClass == null) {
            return entityManagerFactory;
        }
        if (this.emfWrapperClass.isAssignableFrom(entityManagerFactory.getClass())) {
            try {
                return (EntityManagerFactory)this.emfGetDelegateMethod.invoke((Object)entityManagerFactory, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new JpaGpsDeviceException("Failed to invoke getDelegate method on [" + entityManagerFactory + "]", e.getTargetException());
            }
            catch (Exception e) {
                throw new JpaGpsDeviceException("Failed to invoke getDelegate method on [" + entityManagerFactory + "]", e);
            }
        }
        return entityManagerFactory;
    }

    public EntityManager extractNative(EntityManager entityManager) throws JpaGpsDeviceException {
        if (this.emWrapperClass == null) {
            return entityManager;
        }
        if (this.emWrapperClass.isAssignableFrom(entityManager.getClass())) {
            try {
                return (EntityManager)this.emGetDelegateMethod.invoke((Object)entityManager, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new JpaGpsDeviceException("Failed to invoke getDelegate method on [" + entityManager + "]", e.getTargetException());
            }
            catch (Exception e) {
                throw new JpaGpsDeviceException("Failed to invoke getDelegate method on [" + entityManager + "]", e);
            }
        }
        return entityManager;
    }
}

