/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.embedded.toplink;

import java.util.Vector;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.descriptors.DescriptorEventListener;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.sessions.Session;
import org.compass.core.mapping.Cascade;
import org.compass.gps.device.jpa.AbstractDeviceJpaEntityListener;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.embedded.toplink.TopLinkHelper;

public class EmbeddedToplinkEventListener
extends AbstractDeviceJpaEntityListener
implements DescriptorEventListener {
    private JpaGpsDevice device;

    public EmbeddedToplinkEventListener(JpaGpsDevice device) {
        this.device = device;
    }

    protected JpaGpsDevice getDevice() {
        return this.device;
    }

    public void postUpdate(DescriptorEvent event) {
        block5: {
            if (this.disable()) {
                return;
            }
            Object entity = event.getObject();
            if (!this.hasMappingForEntity(entity.getClass(), Cascade.SAVE)) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Updating [" + entity + "]"));
                }
                AbstractSession session = event.getSession();
                TopLinkHelper.getCurrentCompassSession((Session)session).save(entity);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed while updating [" + entity + "]"), (Throwable)e);
                if (!this.throwExceptionOnError()) break block5;
                throw new JpaGpsDeviceException("Failed while updating [" + entity + "]", e);
            }
        }
    }

    public void postDelete(DescriptorEvent event) {
        block5: {
            if (this.disable()) {
                return;
            }
            Object entity = event.getObject();
            if (!this.hasMappingForEntity(entity.getClass(), Cascade.DELETE)) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Deleting [" + entity + "]"));
                }
                AbstractSession session = event.getSession();
                TopLinkHelper.getCurrentCompassSession((Session)session).delete(entity);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed while deleting [" + entity + "]"), (Throwable)e);
                if (!this.throwExceptionOnError()) break block5;
                throw new JpaGpsDeviceException("Failed while deleting [" + entity + "]", e);
            }
        }
    }

    public void postInsert(DescriptorEvent event) {
        block5: {
            if (this.disable()) {
                return;
            }
            Object entity = event.getObject();
            if (!this.hasMappingForEntity(entity.getClass(), Cascade.CREATE)) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Creating [" + entity + "]"));
                }
                AbstractSession session = event.getSession();
                TopLinkHelper.getCurrentCompassSession((Session)session).create(entity);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed while creating [" + entity + "]"), (Throwable)e);
                if (!this.throwExceptionOnError()) break block5;
                throw new JpaGpsDeviceException("Failed while creating [" + entity + "]", e);
            }
        }
    }

    public void aboutToDelete(DescriptorEvent event) {
    }

    public void aboutToInsert(DescriptorEvent event) {
    }

    public void aboutToUpdate(DescriptorEvent event) {
    }

    public boolean isOverriddenEvent(DescriptorEvent event, Vector eventManagers) {
        return false;
    }

    public void postBuild(DescriptorEvent event) {
    }

    public void postClone(DescriptorEvent event) {
    }

    public void postMerge(DescriptorEvent event) {
    }

    public void postRefresh(DescriptorEvent event) {
    }

    public void postWrite(DescriptorEvent event) {
    }

    public void preDelete(DescriptorEvent event) {
    }

    public void preInsert(DescriptorEvent event) {
    }

    public void prePersist(DescriptorEvent event) {
    }

    public void preRemove(DescriptorEvent event) {
    }

    public void preUpdate(DescriptorEvent event) {
    }

    public void preUpdateWithChanges(DescriptorEvent event) {
    }

    public void preWrite(DescriptorEvent event) {
    }
}

