/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.embedded.toplink;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerFactoryImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerSetupImpl;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.essentials.sessions.SessionEventListener;
import oracle.toplink.essentials.threetier.ServerSession;
import oracle.toplink.essentials.tools.sessionconfiguration.SessionCustomizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassConfigurationFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.transaction.JTASyncTransactionFactory;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JtaEntityManagerWrapper;
import org.compass.gps.device.jpa.ResourceLocalEntityManagerWrapper;
import org.compass.gps.device.jpa.embedded.DefaultJpaCompassGps;
import org.compass.gps.device.jpa.embedded.toplink.CompassSessionEventListener;
import org.compass.gps.device.jpa.embedded.toplink.EmbeddedToplinkEventListener;
import org.compass.gps.device.jpa.lifecycle.TopLinkEssentialsJpaEntityLifecycleInjector;

public class CompassSessionCustomizer
implements SessionCustomizer {
    private static final Log log = LogFactory.getLog(CompassSessionCustomizer.class);
    private static final String COMPASS_PREFIX = "compass";
    private static final String COMPASS_GPS_INDEX_PREFIX = "gps.index.";
    public static final String INDEX_QUERY_PREFIX = "compass.toplink.indexQuery.";
    public static final String COMPASS_CONFIG_LOCATION = "compass.toplink.config";
    public static final String COMPASS_SESSION_CUSTOMIZER = "compass.toplink.session.customizer";

    public void customize(Session session) throws Exception {
        boolean toplinkControlledTransaction;
        PersistenceUnitInfo persistenceUnitInfo;
        if (log.isInfoEnabled()) {
            log.info((Object)("Compass embedded TopLink Essentials support enabled, initializing for session [" + session + "]"));
        }
        if ((persistenceUnitInfo = this.findPersistenceUnitInfo(session)) == null) {
            throw new CompassException("Failed to find Persistence Unit Info");
        }
        HashMap<Object, Object> toplinkProps = new HashMap<Object, Object>();
        toplinkProps.putAll(persistenceUnitInfo.getProperties());
        toplinkProps.putAll(session.getProperties());
        String sessionCustomizer = (String)toplinkProps.get(COMPASS_SESSION_CUSTOMIZER);
        if (sessionCustomizer != null) {
            ((SessionCustomizer)ClassUtils.forName(sessionCustomizer, persistenceUnitInfo.getClassLoader()).newInstance()).customize(session);
        }
        Properties compassProperties = new Properties();
        for (Map.Entry entry : toplinkProps.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String key = (String)entry.getKey();
            if (key.startsWith(COMPASS_PREFIX)) {
                compassProperties.put(entry.getKey(), entry.getValue());
            }
            if (!key.startsWith(COMPASS_GPS_INDEX_PREFIX)) continue;
            compassProperties.put(entry.getKey(), entry.getValue());
        }
        if (compassProperties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No Compass properties found in configuraiton, disabling Compass");
            }
            return;
        }
        if (compassProperties.getProperty("compass.engine.connection") == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No Compass [compass.engine.connection] property defined, disabling Compass");
            }
            return;
        }
        CompassConfiguration compassConfiguration = CompassConfigurationFactory.newConfiguration();
        compassConfiguration.setClassLoader(persistenceUnitInfo.getClassLoader());
        CompassSettings settings = compassConfiguration.getSettings();
        settings.addSettings(compassProperties);
        String configLocation = (String)compassProperties.get(COMPASS_CONFIG_LOCATION);
        if (configLocation != null) {
            compassConfiguration.configure(configLocation);
        }
        Map descriptors = session.getDescriptors();
        for (Object o : descriptors.values()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)o;
            Class mappedClass = classDescriptor.getJavaClass();
            compassConfiguration.tryAddClass(mappedClass);
        }
        String transactionFactory = (String)compassProperties.get("compass.transaction.factory");
        if (transactionFactory == null) {
            if (persistenceUnitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA) {
                transactionFactory = JTASyncTransactionFactory.class.getName();
                toplinkControlledTransaction = false;
            } else {
                transactionFactory = LocalTransactionFactory.class.getName();
                toplinkControlledTransaction = true;
            }
            settings.setSetting("compass.transaction.factory", transactionFactory);
        } else {
            toplinkControlledTransaction = false;
        }
        if (settings.getSetting("compass.transaction.disableThreadBoundLocalTransaction") == null) {
            settings.setBooleanSetting("compass.transaction.disableThreadBoundLocalTransaction", true);
        }
        Compass compass = compassConfiguration.buildCompass();
        boolean commitBeforeCompletion = settings.getSettingAsBoolean("compass.transaction.commitBeforeCompletion", false);
        Properties indexProps = new Properties();
        for (Map.Entry<Object, Object> entry : compassProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(COMPASS_GPS_INDEX_PREFIX)) continue;
            indexProps.put(key.substring(COMPASS_GPS_INDEX_PREFIX.length()), entry.getValue());
        }
        EntityManagerFactoryImpl emf = new EntityManagerFactoryImpl((ServerSession)session);
        JpaGpsDevice jpaGpsDevice = new JpaGpsDevice("jpa", (EntityManagerFactory)emf);
        jpaGpsDevice.setMirrorDataChanges(true);
        jpaGpsDevice.setInjectEntityLifecycleListener(true);
        for (Map.Entry<Object, Object> entry : compassProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(INDEX_QUERY_PREFIX)) continue;
            String entityName = key.substring(INDEX_QUERY_PREFIX.length());
            String selectQuery = (String)entry.getValue();
            jpaGpsDevice.setIndexSelectQuery(entityName, selectQuery);
        }
        TopLinkEssentialsJpaEntityLifecycleInjector lifecycleInjector = new TopLinkEssentialsJpaEntityLifecycleInjector();
        lifecycleInjector.setEventListener(new EmbeddedToplinkEventListener(jpaGpsDevice));
        jpaGpsDevice.setLifecycleInjector(lifecycleInjector);
        if (persistenceUnitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            jpaGpsDevice.setEntityManagerWrapper(new JtaEntityManagerWrapper());
        } else {
            jpaGpsDevice.setEntityManagerWrapper(new ResourceLocalEntityManagerWrapper());
        }
        DefaultJpaCompassGps jpaCompassGps = new DefaultJpaCompassGps();
        jpaCompassGps.setCompass(compass);
        jpaCompassGps.addGpsDevice(jpaGpsDevice);
        emf.createEntityManager().close();
        jpaCompassGps.start();
        session.getEventManager().addListener((SessionEventListener)new CompassSessionEventListener(compass, jpaCompassGps, commitBeforeCompletion, toplinkControlledTransaction, indexProps));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Compass embedded TopLink Essentials support active");
        }
    }

    protected PersistenceUnitInfo findPersistenceUnitInfo(Session session) {
        String sessionName = session.getName();
        int index = sessionName.indexOf(45);
        while (index != -1) {
            EntityManagerSetupImpl emSetup;
            String urlAndName = sessionName.substring(0, index) + sessionName.substring(index + 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to find PersistenceInfo using [" + urlAndName + "]"));
            }
            if ((emSetup = EntityManagerFactoryProvider.getEntityManagerSetupImpl((String)urlAndName)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found PersistenceInfo using [" + urlAndName + "]"));
                }
                return emSetup.getPersistenceUnitInfo();
            }
            index = sessionName.indexOf(45, index + 1);
        }
        return null;
    }
}

