/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.embedded;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassConfigurationFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.mapping.Cascade;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.core.transaction.JTASyncTransactionFactory;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.hibernate.lifecycle.HibernateMirrorFilter;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.AbstractCollectionEvent;
import org.hibernate.event.EventSource;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.transaction.CMTTransactionFactory;
import org.hibernate.transaction.JTATransactionFactory;

public class CompassEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
Initializable {
    public static final Log log = LogFactory.getLog(CompassEventListener.class);
    public static final String COMPASS_PREFIX = "compass";
    public static final String COMPASS_GPS_INDEX_PREFIX = "gps.index.";
    public static final String COMPASS_CONFIG_LOCATION = "compass.hibernate.config";
    public static final String COMPASS_MIRROR_FILTER = "compass.hibernate.mirrorFilter";
    public static final String COMPASS_PROCESS_COLLECTIONS = "compass.hibernate.processCollections";
    private static ThreadLocal<WeakHashMap<Configuration, CompassHolder>> contexts = new ThreadLocal();
    private CompassHolder compassHolder;
    private boolean processCollections = true;

    public void initialize(Configuration cfg) {
        this.compassHolder = this.getCompassHolder(cfg);
    }

    public Compass getCompass() {
        return this.compassHolder.compass;
    }

    public Properties getIndexSettings() {
        return this.compassHolder.indexSettings;
    }

    public void onPostDelete(PostDeleteEvent event) {
        if (this.compassHolder == null) {
            return;
        }
        Object entity = event.getEntity();
        if (!this.hasMappingForEntity(entity.getClass(), Cascade.DELETE)) {
            return;
        }
        if (this.compassHolder.mirrorFilter != null && this.compassHolder.mirrorFilter.shouldFilterDelete(event)) {
            return;
        }
        TransactionSyncHolder holder = this.getOrCreateHolder(event.getSession());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deleting [" + entity + "]"));
        }
        holder.session.delete(entity);
        this.afterOperation(holder);
    }

    public void onPostInsert(PostInsertEvent event) {
        if (this.compassHolder == null) {
            return;
        }
        Object entity = event.getEntity();
        if (!this.hasMappingForEntity(entity.getClass(), Cascade.CREATE)) {
            return;
        }
        if (this.compassHolder.mirrorFilter != null && this.compassHolder.mirrorFilter.shouldFilterInsert(event)) {
            return;
        }
        TransactionSyncHolder holder = this.getOrCreateHolder(event.getSession());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating [" + entity + "]"));
        }
        HashSet collectionsBefore = null;
        if (this.processCollections) {
            collectionsBefore = new HashSet(event.getSession().getPersistenceContext().getCollectionEntries().values());
        }
        holder.session.create(entity);
        if (this.processCollections) {
            Collection collectionsAfter = event.getSession().getPersistenceContext().getCollectionEntries().values();
            for (CollectionEntry collection : collectionsAfter) {
                if (collectionsBefore.contains(collection)) continue;
                collection.setProcessed(true);
            }
        }
        this.afterOperation(holder);
    }

    public void onPostUpdate(PostUpdateEvent event) {
        if (this.compassHolder == null) {
            return;
        }
        Object entity = event.getEntity();
        if (!this.hasMappingForEntity(entity.getClass(), Cascade.SAVE)) {
            return;
        }
        if (this.compassHolder.mirrorFilter != null && this.compassHolder.mirrorFilter.shouldFilterUpdate(event)) {
            return;
        }
        TransactionSyncHolder holder = this.getOrCreateHolder(event.getSession());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating [" + entity + "]"));
        }
        HashSet collectionsBefore = null;
        if (this.processCollections) {
            collectionsBefore = new HashSet(event.getSession().getPersistenceContext().getCollectionEntries().values());
        }
        holder.session.save(entity);
        if (this.processCollections) {
            Collection collectionsAfter = event.getSession().getPersistenceContext().getCollectionEntries().values();
            for (CollectionEntry collection : collectionsAfter) {
                if (collectionsBefore.contains(collection)) continue;
                collection.setProcessed(true);
            }
        }
        this.afterOperation(holder);
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent postCollectionRecreateEvent) {
        this.processCollectionEvent((AbstractCollectionEvent)postCollectionRecreateEvent);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent postCollectionRemoveEvent) {
        this.processCollectionEvent((AbstractCollectionEvent)postCollectionRemoveEvent);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent postCollectionUpdateEvent) {
        this.processCollectionEvent((AbstractCollectionEvent)postCollectionUpdateEvent);
    }

    private void processCollectionEvent(AbstractCollectionEvent event) {
        if (this.compassHolder == null) {
            return;
        }
        Object entity = event.getAffectedOwnerOrNull();
        if (entity == null) {
            return;
        }
        CollectionEntry collectionEntry = event.getSession().getPersistenceContext().getCollectionEntry(event.getCollection());
        if (collectionEntry != null && collectionEntry.getLoadedPersister() == null) {
            return;
        }
        if (!this.hasMappingForEntity(entity.getClass(), Cascade.SAVE)) {
            return;
        }
        Serializable id = this.getId(entity, event);
        if (id == null) {
            log.warn((Object)("Unable to reindex entity on collection change, id cannot be extracted: " + event.getAffectedOwnerEntityName()));
            return;
        }
        if (this.compassHolder.mirrorFilter != null && this.compassHolder.mirrorFilter.shouldFilterCollection(event)) {
            return;
        }
        TransactionSyncHolder holder = this.getOrCreateHolder(event.getSession());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating [" + entity + "]"));
        }
        holder.session.save(entity);
        this.afterOperation(holder);
    }

    private Serializable getId(Object entity, AbstractCollectionEvent event) {
        Serializable id = event.getAffectedOwnerIdOrNull();
        if (id == null) {
            EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
            id = entityEntry == null ? null : entityEntry.getId();
        }
        return id;
    }

    private TransactionSyncHolder getOrCreateHolder(EventSource session) {
        if (session.isTransactionInProgress()) {
            Transaction transaction = session.getTransaction();
            TransactionSyncHolder holder = this.compassHolder.syncHolderPerTx.get(transaction);
            if (holder == null) {
                holder = new TransactionSyncHolder();
                holder.session = this.compassHolder.compass.openSession();
                holder.tr = holder.session.beginTransaction();
                holder.transacted = true;
                transaction.registerSynchronization((Synchronization)new CompassEmbeddedSyncronization(holder, transaction));
                this.compassHolder.syncHolderPerTx.put(transaction, holder);
            }
            return holder;
        }
        TransactionSyncHolder holder = new TransactionSyncHolder();
        holder.session = this.compassHolder.compass.openSession();
        holder.tr = holder.session.beginTransaction();
        holder.transacted = false;
        return holder;
    }

    private void afterOperation(TransactionSyncHolder holder) {
        if (holder.transacted) {
            return;
        }
        holder.tr.commit();
        holder.session.close();
    }

    private CompassHolder getCompassHolder(Configuration cfg) {
        CompassHolder compassHolder;
        WeakHashMap<Object, CompassHolder> contextMap = contexts.get();
        if (contextMap == null) {
            contextMap = new WeakHashMap(2);
            contexts.set(contextMap);
        }
        if ((compassHolder = contextMap.get(cfg)) == null && (compassHolder = this.initCompassHolder(cfg)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Regsitering new Compass Holder [" + compassHolder + "]"));
            }
            contextMap.put(cfg, compassHolder);
        }
        return compassHolder;
    }

    private CompassHolder initCompassHolder(Configuration cfg) {
        Properties compassProperties = new Properties();
        Properties props = cfg.getProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(COMPASS_PREFIX)) {
                compassProperties.put(entry.getKey(), entry.getValue());
            }
            if (!key.startsWith(COMPASS_GPS_INDEX_PREFIX)) continue;
            compassProperties.put(entry.getKey(), entry.getValue());
        }
        if (compassProperties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No Compass properties defined, disabling Compass");
            }
            return null;
        }
        if (compassProperties.getProperty("compass.engine.connection") == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No Compass [compass.engine.connection] property defined, disabling Compass");
            }
            return null;
        }
        this.processCollections = compassProperties.getProperty(COMPASS_PROCESS_COLLECTIONS, "true").equalsIgnoreCase("true");
        CompassConfiguration compassConfiguration = CompassConfigurationFactory.newConfiguration();
        CompassSettings settings = compassConfiguration.getSettings();
        settings.addSettings(compassProperties);
        String configLocation = (String)compassProperties.get(COMPASS_CONFIG_LOCATION);
        if (configLocation != null) {
            compassConfiguration.configure(configLocation);
        }
        boolean atleastOneClassAdded = false;
        Iterator it = cfg.getClassMappings();
        while (it.hasNext()) {
            PersistentClass clazz = (PersistentClass)it.next();
            Class mappedClass = clazz.getMappedClass();
            Iterator propIt = clazz.getPropertyIterator();
            while (propIt.hasNext()) {
                Property prop = (Property)propIt.next();
                Value value = prop.getValue();
                if (!(value instanceof Component)) continue;
                Component component = (Component)value;
                try {
                    atleastOneClassAdded |= compassConfiguration.tryAddClass(ClassUtils.forName(component.getComponentClassName(), settings.getClassLoader()));
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Failed to load component class [" + component.getComponentClassName() + "]"), (Throwable)e);
                }
            }
            Value idValue = clazz.getIdentifierProperty().getValue();
            if (idValue instanceof Component) {
                Component component = (Component)idValue;
                try {
                    atleastOneClassAdded |= compassConfiguration.tryAddClass(ClassUtils.forName(component.getComponentClassName(), settings.getClassLoader()));
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Failed to load component class [" + component.getComponentClassName() + "]"), (Throwable)e);
                }
            }
            atleastOneClassAdded |= compassConfiguration.tryAddClass(mappedClass);
        }
        if (!atleastOneClassAdded) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No searchable class mappings found in Hibernate class mappings, disabling Compass");
            }
            return null;
        }
        CompassHolder compassHolder = new CompassHolder();
        compassHolder.compassProperties = compassProperties;
        compassHolder.commitBeforeCompletion = settings.getSettingAsBoolean("compass.transaction.commitBeforeCompletion", false);
        String transactionFactory = (String)compassProperties.get("compass.transaction.factory");
        if (transactionFactory == null) {
            String hibernateTransactionStrategy = cfg.getProperty("hibernate.transaction.factory_class");
            if (CMTTransactionFactory.class.getName().equals(hibernateTransactionStrategy) || JTATransactionFactory.class.getName().equals(hibernateTransactionStrategy)) {
                compassHolder.hibernateControlledTransaction = false;
                compassConfiguration.setSetting("compass.transaction.factory", JTASyncTransactionFactory.class.getName());
            } else {
                compassHolder.hibernateControlledTransaction = true;
                if (settings.getSetting("compass.transaction.disableThreadBoundLocalTransaction") == null) {
                    settings.setBooleanSetting("compass.transaction.disableThreadBoundLocalTransaction", true);
                }
            }
        } else if (LocalTransactionFactory.class.getName().equals(transactionFactory)) {
            compassHolder.hibernateControlledTransaction = true;
            if (settings.getSetting("compass.transaction.disableThreadBoundLocalTransaction") == null) {
                settings.setBooleanSetting("compass.transaction.disableThreadBoundLocalTransaction", true);
            }
        } else {
            compassHolder.hibernateControlledTransaction = false;
        }
        compassHolder.indexSettings = new Properties();
        for (Map.Entry<Object, Object> entry : compassProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(COMPASS_GPS_INDEX_PREFIX)) continue;
            compassHolder.indexSettings.put(key.substring(COMPASS_GPS_INDEX_PREFIX.length()), entry.getValue());
        }
        String mirrorFilterClass = compassHolder.compassProperties.getProperty(COMPASS_MIRROR_FILTER);
        if (mirrorFilterClass != null) {
            try {
                compassHolder.mirrorFilter = (HibernateMirrorFilter)ClassUtils.forName(mirrorFilterClass, compassConfiguration.getSettings().getClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new CompassException("Failed to create mirror filter [" + mirrorFilterClass + "]", e);
            }
        }
        compassHolder.compass = compassConfiguration.buildCompass();
        return compassHolder;
    }

    private boolean hasMappingForEntity(Class clazz, Cascade cascade) {
        ResourceMapping resourceMapping = ((InternalCompass)this.compassHolder.compass).getMapping().getRootMappingByClass(clazz);
        if (resourceMapping != null) {
            return true;
        }
        resourceMapping = ((InternalCompass)this.compassHolder.compass).getMapping().getNonRootMappingByClass(clazz);
        if (resourceMapping == null) {
            return false;
        }
        return resourceMapping.operationAllowed(cascade);
    }

    private class CompassEmbeddedSyncronization
    implements Synchronization {
        private Transaction transaction;
        private TransactionSyncHolder holder;

        private CompassEmbeddedSyncronization(TransactionSyncHolder holder, Transaction transaction) {
            this.holder = holder;
            this.transaction = transaction;
        }

        public void beforeCompletion() {
            if (!((CompassEventListener)CompassEventListener.this).compassHolder.commitBeforeCompletion) {
                return;
            }
            if (this.holder.session.isClosed()) {
                return;
            }
            if (((CompassEventListener)CompassEventListener.this).compassHolder.hibernateControlledTransaction) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Committing compass transaction using Hibernate synchronization beforeCompletion on thread [" + Thread.currentThread().getName() + "]"));
                }
                this.holder.tr.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            block14: {
                try {
                    if (this.holder.session.isClosed()) {
                        return;
                    }
                    if (((CompassEventListener)CompassEventListener.this).compassHolder.commitBeforeCompletion || !((CompassEventListener)CompassEventListener.this).compassHolder.hibernateControlledTransaction) break block14;
                    try {
                        if (status == 3) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Committing compass transaction using Hibernate synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                            }
                            this.holder.tr.commit();
                        } else {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Rolling back compass transaction using Hibernate synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                            }
                            this.holder.tr.rollback();
                        }
                    }
                    finally {
                        this.holder.session.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Exception occured when sync with transaction", (Throwable)e);
                }
                finally {
                    ((CompassEventListener)CompassEventListener.this).compassHolder.syncHolderPerTx.remove(this.transaction);
                }
            }
        }
    }

    private class TransactionSyncHolder {
        public CompassSession session;
        public CompassTransaction tr;
        public boolean transacted;

        private TransactionSyncHolder() {
        }
    }

    private class CompassHolder {
        ConcurrentHashMap<Transaction, TransactionSyncHolder> syncHolderPerTx = new ConcurrentHashMap();
        Properties compassProperties;
        Properties indexSettings;
        boolean commitBeforeCompletion;
        boolean hibernateControlledTransaction;
        HibernateMirrorFilter mirrorFilter;
        Compass compass;

        private CompassHolder() {
        }
    }
}

