/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.jdom.converter.support;

import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.compass.core.xml.jdom.converter.support.StAXTextModifier;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.UncheckedJDOMFactory;
import org.jdom.output.XMLOutputter;

public class StAXBuilder {
    static final HashMap<String, Integer> attrTypes = new HashMap(32);
    private JDOMFactory factory = null;
    protected boolean cfgIgnoreWS = false;
    protected StAXTextModifier textModifier = null;

    public void setFactory(JDOMFactory f) {
        this.factory = f;
    }

    public void setTextModifier(StAXTextModifier mod) {
        this.textModifier = mod;
    }

    public void setIgnoreWhitespace(boolean state) {
        this.cfgIgnoreWS = state;
    }

    public void setRemoveIndentation(boolean state) {
        if (state) {
            this.setTextModifier(IndentRemover.getInstance());
        } else {
            this.setTextModifier(null);
        }
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public Document build(XMLStreamReader r) throws XMLStreamException {
        JDOMFactory f = this.factory;
        if (f == null) {
            f = new UncheckedJDOMFactory();
        }
        Document doc = f.document(null);
        this.buildTree(f, r, doc, this.textModifier);
        return doc;
    }

    protected void buildTree(JDOMFactory f, XMLStreamReader r, Document doc, StAXTextModifier tmod) throws XMLStreamException {
        Element current = null;
        boolean allowTextMods = tmod != null;
        int evtType = 7;
        block14: while (true) {
            CDATA child;
            int prevEvent = evtType;
            evtType = r.next();
            if (allowTextMods && evtType == 4 && tmod.possiblyModifyText(r, prevEvent)) {
                String txt = r.getText();
                evtType = r.next();
                txt = tmod.textToIncludeBetween(r, prevEvent, evtType, txt);
                if (txt != null && txt.length() > 0 && current != null) {
                    f.addContent((Parent)current, (Content)f.text(txt));
                }
                prevEvent = 4;
            }
            switch (evtType) {
                case 12: {
                    child = f.cdata(r.getText());
                    break;
                }
                case 6: {
                    if (this.cfgIgnoreWS) continue block14;
                }
                case 4: {
                    if (current == null) continue block14;
                    child = f.text(r.getText());
                    break;
                }
                case 5: {
                    child = f.comment(r.getText());
                    break;
                }
                case 8: {
                    break block14;
                }
                case 2: {
                    current = current.getParentElement();
                    if (tmod == null) continue block14;
                    allowTextMods = tmod.allowModificationsAfter(r, evtType);
                    continue block14;
                }
                case 14: 
                case 15: {
                    continue block14;
                }
                case 9: {
                    child = f.entityRef(r.getLocalName());
                    break;
                }
                case 3: {
                    child = f.processingInstruction(r.getPITarget(), r.getPIData());
                    break;
                }
                case 1: {
                    Namespace ns;
                    String prefix;
                    int i;
                    Element newElem = null;
                    String nsURI = r.getNamespaceURI();
                    String elemPrefix = r.getPrefix();
                    String ln = r.getLocalName();
                    newElem = nsURI == null || nsURI.length() == 0 ? (elemPrefix == null || elemPrefix.length() == 0 ? f.element(ln) : f.element(ln, elemPrefix, "")) : f.element(ln, elemPrefix, nsURI);
                    if (current == null) {
                        doc.setRootElement(newElem);
                    } else {
                        f.addContent((Parent)current, (Content)newElem);
                    }
                    int len = r.getNamespaceCount();
                    for (i = 0; i < len; ++i) {
                        prefix = r.getNamespacePrefix(i);
                        if (prefix == null) {
                            prefix = "";
                        }
                        ns = Namespace.getNamespace((String)prefix, (String)r.getNamespaceURI(i));
                        if (prefix.equals(elemPrefix)) continue;
                        f.addNamespaceDeclaration(newElem, ns);
                    }
                    len = r.getAttributeCount();
                    for (i = 0; i < len; ++i) {
                        prefix = r.getAttributePrefix(i);
                        ns = prefix == null || prefix.length() == 0 ? Namespace.NO_NAMESPACE : newElem.getNamespace(prefix);
                        Attribute attr = f.attribute(r.getAttributeLocalName(i), r.getAttributeValue(i), StAXBuilder.resolveAttrType(r.getAttributeType(i)), ns);
                        f.setAttribute(newElem, attr);
                    }
                    current = newElem;
                    if (tmod == null) continue block14;
                    allowTextMods = tmod.allowModificationsAfter(r, evtType);
                    continue block14;
                }
                case 7: {
                    continue block14;
                }
                case 11: {
                    continue block14;
                }
                default: {
                    throw new XMLStreamException("Unrecognized iterator event type: " + r.getEventType() + "; should not receive such types (broken stream reader?)");
                }
            }
            if (child == null) continue;
            if (current == null) {
                f.addContent((Parent)doc, (Content)child);
                continue;
            }
            f.addContent((Parent)current, (Content)child);
        }
    }

    protected boolean isIndentationWhitespace(XMLStreamReader r) throws XMLStreamException {
        String text = r.getText();
        if (text.length() > 0) {
            char c = text.charAt(0);
            return c == '\n' || c == '\r';
        }
        return false;
    }

    private static int resolveAttrType(String typeStr) {
        Integer I;
        if (typeStr != null && typeStr.length() > 0 && (I = attrTypes.get(typeStr)) != null) {
            return I;
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java ... [file]");
            System.exit(1);
        }
        String filename = args[0];
        FileReader r = new FileReader(filename);
        XMLInputFactory f = XMLInputFactory.newInstance();
        XMLStreamReader sr = f.createXMLStreamReader(r);
        StAXBuilder builder = new StAXBuilder();
        Document domDoc = builder.build(sr);
        System.out.println("Done [with " + sr.getClass() + "]:");
        System.out.println("----- JDom -----");
        XMLOutputter outputter = new XMLOutputter();
        PrintWriter pw = new PrintWriter(System.out);
        outputter.output(domDoc, (Writer)pw);
        pw.flush();
        System.out.println("----- /JDom -----");
    }

    static {
        attrTypes.put("CDATA", 1);
        attrTypes.put("cdata", 1);
        attrTypes.put("ID", 2);
        attrTypes.put("id", 2);
        attrTypes.put("IDREF", 3);
        attrTypes.put("idref", 3);
        attrTypes.put("IDREFS", 4);
        attrTypes.put("idrefs", 4);
        attrTypes.put("ENTITY", 5);
        attrTypes.put("entity", 5);
        attrTypes.put("ENTITIES", 6);
        attrTypes.put("entities", 6);
        attrTypes.put("NMTOKEN", 7);
        attrTypes.put("nmtoken", 7);
        attrTypes.put("NMTOKENS", 8);
        attrTypes.put("nmtokens", 8);
        attrTypes.put("NOTATION", 9);
        attrTypes.put("notation", 9);
        attrTypes.put("ENUMERATED", 10);
        attrTypes.put("enumerated", 10);
    }

    public static class IndentRemover
    extends StAXTextModifier {
        static final IndentRemover sInstance = new IndentRemover();

        protected IndentRemover() {
        }

        public static IndentRemover getInstance() {
            return sInstance;
        }

        public boolean allowModificationsAfter(XMLStreamReader r, int eventType) throws XMLStreamException {
            return true;
        }

        public boolean possiblyModifyText(XMLStreamReader r, int prevEvent) throws XMLStreamException {
            String txt;
            if (r.getEventType() == 4 && prevEvent != 4 && prevEvent != 12 && prevEvent != 9 && r.isWhiteSpace() && (txt = r.getText()).length() > 0) {
                char c = txt.charAt(0);
                return c == '\n' || c == '\r';
            }
            return false;
        }

        public String textToIncludeBetween(XMLStreamReader r, int prevEvent, int nextEvent, String text) throws XMLStreamException {
            if (nextEvent == 4 || nextEvent == 12 || nextEvent == 9) {
                return text;
            }
            return null;
        }
    }
}

