/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.javax.converter;

import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.xml.AliasedXmlObject;
import org.compass.core.xml.javax.NodeAliasedXmlObject;
import org.compass.core.xml.javax.converter.NodeXmlContentConverter;
import org.compass.core.xml.javax.converter.support.Stax2DomBuilder;
import org.w3c.dom.Document;

public class StaxNodeXmlContentConverter
extends NodeXmlContentConverter {
    private static Log log = LogFactory.getLog(StaxNodeXmlContentConverter.class);
    private XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private Stax2DomBuilder staxBuilder;

    public void configure(CompassSettings settings) throws CompassException {
        super.configure(settings);
        this.staxBuilder = new Stax2DomBuilder();
    }

    public AliasedXmlObject fromXml(String alias, Reader xml) throws ConversionException {
        Document document;
        try {
            XMLStreamReader sr = this.inputFactory.createXMLStreamReader(xml);
            document = this.staxBuilder.build(sr, this.documentBuilder);
        }
        catch (Exception e) {
            throw new ConversionException("Failed to parse alias[" + alias + "] xml[" + xml + "]", e);
        }
        return new NodeAliasedXmlObject(alias, document);
    }
}

