/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.xsem.builder;

import org.compass.core.engine.subindex.ConstantSubIndexHash;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourceMappingProvider;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.mapping.xsem.builder.XmlAllMappingBuilder;
import org.compass.core.mapping.xsem.builder.XmlAnalyzerMappingBuilder;
import org.compass.core.mapping.xsem.builder.XmlBoostMappingBuilder;
import org.compass.core.mapping.xsem.builder.XmlContentMappingBuilder;
import org.compass.core.mapping.xsem.builder.XmlIdMappingBuilder;
import org.compass.core.mapping.xsem.builder.XmlPropertyMappingBuilder;

public class XmlMappingBuilder
implements ResourceMappingProvider {
    private final XmlObjectMapping mapping = new XmlObjectMapping();

    public XmlMappingBuilder(String alias) {
        this.mapping.setAlias(alias);
        this.mapping.setRoot(true);
    }

    public ResourceMapping getMapping() {
        return this.mapping;
    }

    public XmlMappingBuilder xpath(String xpath) {
        this.mapping.setXPath(xpath);
        return this;
    }

    public XmlMappingBuilder subIndex(String subIndex) {
        this.mapping.setSubIndexHash(new ConstantSubIndexHash(subIndex));
        return this;
    }

    public XmlMappingBuilder subIndex(SubIndexHash subIndexHash) {
        this.mapping.setSubIndexHash(subIndexHash);
        return this;
    }

    public XmlMappingBuilder extendsAliases(String ... extendedAliases) {
        this.mapping.setExtendedAliases(extendedAliases);
        return this;
    }

    public XmlMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }

    public XmlMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public XmlMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public XmlMappingBuilder all(XmlAllMappingBuilder allMappingBuilder) {
        this.mapping.setAllMapping(allMappingBuilder.mapping);
        return this;
    }

    public XmlMappingBuilder add(XmlIdMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public XmlMappingBuilder add(XmlPropertyMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public XmlMappingBuilder add(XmlAnalyzerMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public XmlMappingBuilder add(XmlBoostMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public XmlMappingBuilder add(XmlContentMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }
}

