/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.json.builder;

import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.json.JsonPropertyAnalyzerController;

public class JsonAnalyzerMappingBuilder {
    final JsonPropertyAnalyzerController mapping = new JsonPropertyAnalyzerController();

    public JsonAnalyzerMappingBuilder(String name) {
        this.mapping.setName(name);
        this.mapping.setPath(new StaticPropertyPath(name));
    }

    public JsonAnalyzerMappingBuilder nullAnalyzer(String nullAnalyzer) {
        this.mapping.setNullAnalyzer(nullAnalyzer);
        return this;
    }

    public JsonAnalyzerMappingBuilder mappingConverter(String converterName) {
        this.mapping.setConverterName(converterName);
        return this;
    }

    public JsonAnalyzerMappingBuilder mappingConverter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public JsonAnalyzerMappingBuilder valueConverter(String converterName) {
        this.mapping.setValueConverterName(converterName);
        return this;
    }

    public JsonAnalyzerMappingBuilder valueConverter(Converter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }

    public JsonAnalyzerMappingBuilder valueConverter(ResourcePropertyConverter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }
}

