/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support.job;

import org.apache.lucene.index.IndexWriter;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.transaction.support.WriterHelper;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;
import org.compass.core.spi.InternalResource;

public class UpdateTransactionJob
implements TransactionJob {
    private final InternalResource resource;
    private final String resourceUID;

    public UpdateTransactionJob(InternalResource resource) {
        this.resource = resource;
        this.resourceUID = resource.getResourceKey().buildUID();
    }

    public String getSubIndex() {
        return this.resource.getSubIndex();
    }

    public String getResourceUID() {
        return this.resourceUID;
    }

    public InternalResource getResource() {
        return this.resource;
    }

    public void execute(IndexWriter writer, LuceneSearchEngineFactory sessionFactory) throws Exception {
        this.resource.attach(sessionFactory);
        WriterHelper.processUpdate(writer, this.resource);
    }

    public String toString() {
        return "Job Update [" + this.resource.getResourceKey() + "] Resource [" + this.resource + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateTransactionJob that = (UpdateTransactionJob)o;
        return this.resourceUID.equals(that.resourceUID);
    }

    public int hashCode() {
        return 29 * this.resourceUID.hashCode();
    }
}

