/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support.job;

import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Query;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.transaction.support.WriterHelper;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;

public class DeleteByQueryTransactionJob
implements TransactionJob {
    private final Query query;
    private final String subIndex;

    public DeleteByQueryTransactionJob(Query query, String subIndex) {
        this.query = query;
        this.subIndex = subIndex;
    }

    public String getSubIndex() {
        return this.subIndex;
    }

    public String getResourceUID() {
        return null;
    }

    public Query getQuery() {
        return this.query;
    }

    public void execute(IndexWriter writer, LuceneSearchEngineFactory sessionFactory) throws Exception {
        WriterHelper.processDelete(writer, this.query);
    }

    public String toString() {
        return "Job Delete [" + this.query + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteByQueryTransactionJob that = (DeleteByQueryTransactionJob)o;
        return this.subIndex.equals(that.subIndex) && this.query.equals(that.query);
    }

    public int hashCode() {
        return 31 * this.query.hashCode() + this.subIndex.hashCode();
    }
}

