/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.readcommitted;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;

public class BitSetByAliasFilter
extends Filter {
    private boolean concurrent;
    private final Map<IndexReader, DocIdSet> deletedBitSets;
    private final Map<IndexReader, DocIdSet> allBitSets;
    private volatile boolean hasDeletes = false;

    public BitSetByAliasFilter(boolean concurrent) {
        if (concurrent) {
            this.deletedBitSets = new ConcurrentHashMap<IndexReader, DocIdSet>();
            this.allBitSets = new ConcurrentHashMap<IndexReader, DocIdSet>();
        } else {
            this.deletedBitSets = new HashMap<IndexReader, DocIdSet>();
            this.allBitSets = new HashMap<IndexReader, DocIdSet>();
        }
    }

    public void clear() {
        this.deletedBitSets.clear();
        this.allBitSets.clear();
        this.hasDeletes = false;
    }

    public boolean hasDeletes() {
        return this.hasDeletes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDelete(IndexReader indexReader, int docNum, int maxDoc) {
        OpenBitSet bitSet = (OpenBitSet)this.deletedBitSets.get(indexReader);
        if (this.concurrent) {
            if (bitSet == null) {
                Map<IndexReader, DocIdSet> map = this.deletedBitSets;
                synchronized (map) {
                    bitSet = this.initBitSet(indexReader, maxDoc);
                }
            }
        } else if (bitSet == null) {
            bitSet = this.initBitSet(indexReader, maxDoc);
        }
        bitSet.fastClear(docNum);
        this.hasDeletes = true;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocIdSet bitSet = this.deletedBitSets.get(reader);
        if (bitSet != null) {
            return bitSet;
        }
        bitSet = this.allBitSets.get(reader);
        if (bitSet == null) {
            bitSet = new AllSetBitSet(reader.maxDoc());
            this.allBitSets.put(reader, bitSet);
        }
        return bitSet;
    }

    private OpenBitSet initBitSet(IndexReader indexReader, int maxDoc) {
        OpenBitSet bitSet = (OpenBitSet)this.deletedBitSets.get(indexReader);
        if (bitSet == null) {
            bitSet = new OpenBitSet((long)maxDoc);
            bitSet.set(0L, (long)maxDoc);
            this.deletedBitSets.put(indexReader, (DocIdSet)bitSet);
            this.allBitSets.remove(indexReader);
        }
        return bitSet;
    }

    public static class AllSetBitSet
    extends DocIdSet {
        private int size;

        public AllSetBitSet(int size) {
            this.size = size;
        }

        public DocIdSetIterator iterator() {
            return new AllDocIdSetIterator();
        }

        private class AllDocIdSetIterator
        extends DocIdSetIterator {
            private int currentDoc = -1;

            private AllDocIdSetIterator() {
            }

            public int doc() {
                return this.currentDoc;
            }

            public boolean next() throws IOException {
                return ++this.currentDoc < AllSetBitSet.this.size;
            }

            public boolean skipTo(int target) throws IOException {
                this.currentDoc += target;
                return this.currentDoc < AllSetBitSet.this.size;
            }
        }
    }
}

