/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.SearchEngineFactoryAware;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineOptimizer;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.optimizer.DefaultLuceneSearchEngineOptimizer;
import org.compass.core.lucene.engine.optimizer.LuceneSearchEngineOptimizer;

public class LuceneSearchEngineOptimizerManager
implements CompassConfigurable,
SearchEngineOptimizer {
    private static final Log logger = LogFactory.getLog(LuceneSearchEngineOptimizerManager.class);
    private LuceneSearchEngineFactory searchEngineFactory;
    private LuceneSearchEngineOptimizer searchEngineOptimizer;
    private ScheduledFuture scheduledFuture;
    private volatile boolean started = false;

    public LuceneSearchEngineOptimizerManager(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
    }

    public void configure(CompassSettings settings) throws CompassException {
        this.searchEngineOptimizer = (LuceneSearchEngineOptimizer)settings.getSettingAsInstance("compass.engine.optimizer.type", DefaultLuceneSearchEngineOptimizer.class.getName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using optimizer [" + this.searchEngineOptimizer + "]"));
        }
        if (this.searchEngineOptimizer instanceof SearchEngineFactoryAware) {
            ((SearchEngineFactoryAware)((Object)this.searchEngineOptimizer)).setSearchEngineFactory(this.searchEngineFactory);
        }
    }

    public void start() throws SearchEngineException {
        boolean scheduledOptimizer;
        if (this.started) {
            return;
        }
        this.started = true;
        CompassSettings settings = this.searchEngineFactory.getSettings();
        if (this.searchEngineOptimizer.canBeScheduled() && (scheduledOptimizer = this.searchEngineFactory.getSettings().getSettingAsBoolean("compass.engine.optimizer.schedule", true))) {
            long period = (long)(settings.getSettingAsFloat("compass.engine.optimizer.schedule.period", 10.0f) * 1000.0f);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Starting scheduled optimizer [" + this.searchEngineOptimizer.getClass() + "] with period [" + period + "ms]"));
            }
            ScheduledOptimizeRunnable scheduledOptimizeRunnable = new ScheduledOptimizeRunnable(this.searchEngineOptimizer);
            this.scheduledFuture = this.searchEngineFactory.getExecutorManager().scheduleWithFixedDelay(scheduledOptimizeRunnable, period, period, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() throws SearchEngineException {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    public boolean isRunning() {
        return this.scheduledFuture != null;
    }

    public void optimize() throws SearchEngineException {
        this.searchEngineOptimizer.optimize();
    }

    public void optimize(String subIndex) throws SearchEngineException {
        this.searchEngineOptimizer.optimize(subIndex);
    }

    public void optimize(int maxNumberOfSegments) throws SearchEngineException {
        this.searchEngineOptimizer.optimize(maxNumberOfSegments);
    }

    public void optimize(String subIndex, int maxNumberOfSegments) throws SearchEngineException {
        this.searchEngineOptimizer.optimize(subIndex, maxNumberOfSegments);
    }

    private static class ScheduledOptimizeRunnable
    implements Runnable {
        private LuceneSearchEngineOptimizer optimizer;

        public ScheduledOptimizeRunnable(LuceneSearchEngineOptimizer optimizer) {
            this.optimizer = optimizer;
        }

        public void run() {
            block2: {
                try {
                    this.optimizer.optimize();
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block2;
                    logger.debug((Object)"Failed to optimize", (Throwable)e);
                }
            }
        }
    }
}

