/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.compass.core.CompassQuery;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryFilter;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQueryFilter;
import org.compass.core.lucene.engine.queryparser.QueryHolder;
import org.compass.core.lucene.search.CountHitCollector;

public class LuceneSearchEngineQuery
implements SearchEngineQuery,
Cloneable {
    private final LuceneSearchEngineFactory searchEngineFactory;
    private ArrayList<SortField> sortFields = new ArrayList();
    private String[] subIndexes;
    private String[] aliases;
    private LuceneSearchEngineQueryFilter filter;
    private Query origQuery;
    private Query query;
    private String defaultSearchProperty;
    private boolean rewrite;
    private boolean suggested;

    public LuceneSearchEngineQuery(LuceneSearchEngineFactory searchEngineFactory, Query query) {
        this(searchEngineFactory, new QueryHolder(query));
    }

    public LuceneSearchEngineQuery(LuceneSearchEngineFactory searchEngineFactory, QueryHolder query) {
        this(searchEngineFactory, query, searchEngineFactory.getLuceneSettings().getDefaultSearchPropery());
    }

    public LuceneSearchEngineQuery(LuceneSearchEngineFactory searchEngineFactory, QueryHolder query, String defualtSearchProperty) {
        this.searchEngineFactory = searchEngineFactory;
        this.query = query.getQuery();
        this.origQuery = query.getQuery();
        this.suggested = query.isSuggested();
        this.defaultSearchProperty = defualtSearchProperty;
    }

    public SearchEngineQuery addSort(String propertyName) {
        this.sortFields.add(new SortField(propertyName));
        return this;
    }

    public SearchEngineQuery addSort(String propertyName, CompassQuery.SortDirection direction) {
        this.sortFields.add(new SortField(propertyName, this.getSortReverse(direction)));
        return this;
    }

    public SearchEngineQuery addSort(String propertyName, CompassQuery.SortPropertyType type) {
        this.sortFields.add(new SortField(propertyName, this.getSortType(type)));
        return this;
    }

    public SearchEngineQuery addSort(String propertyName, CompassQuery.SortPropertyType type, CompassQuery.SortDirection direction) {
        this.sortFields.add(new SortField(propertyName, this.getSortType(type), this.getSortReverse(direction)));
        return this;
    }

    public SearchEngineQuery addSort(CompassQuery.SortImplicitType implicitType) {
        this.sortFields.add(new SortField(null, this.getImplicitSortField(implicitType)));
        return this;
    }

    public SearchEngineQuery addSort(CompassQuery.SortImplicitType implicitType, CompassQuery.SortDirection direction) {
        this.sortFields.add(new SortField(null, this.getImplicitSortField(implicitType), this.getSortReverse(direction)));
        return this;
    }

    public SearchEngineQuery addSort(String propertyName, Locale locale, CompassQuery.SortDirection direction) {
        this.sortFields.add(new SortField(propertyName, locale, this.getSortReverse(direction)));
        return this;
    }

    public SearchEngineQuery addSort(String propertyName, Locale locale) {
        this.sortFields.add(new SortField(propertyName, locale));
        return this;
    }

    public SearchEngineQuery addSort(SortField sortField) {
        this.sortFields.add(sortField);
        return this;
    }

    public Sort getSort() {
        if (this.sortFields.size() == 0) {
            return null;
        }
        SortField[] sortFieldsArr = this.sortFields.toArray(new SortField[this.sortFields.size()]);
        return new Sort(sortFieldsArr);
    }

    private int getImplicitSortField(CompassQuery.SortImplicitType implicitType) {
        switch (implicitType) {
            case DOC: {
                return 1;
            }
            case SCORE: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Faile to create lucene implicit type for [" + (Object)((Object)implicitType) + "]");
    }

    private boolean getSortReverse(CompassQuery.SortDirection direction) {
        return direction == CompassQuery.SortDirection.REVERSE;
    }

    private int getSortType(CompassQuery.SortPropertyType type) {
        switch (type) {
            case AUTO: {
                return 2;
            }
            case BYTE: {
                return 10;
            }
            case DOUBLE: {
                return 7;
            }
            case FLOAT: {
                return 5;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 6;
            }
            case STRING: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Failed to convert type [" + (Object)((Object)type) + "]");
    }

    public SearchEngineHits hits(SearchEngine searchEngine) {
        return ((LuceneSearchEngine)searchEngine).find(this);
    }

    public long count(SearchEngine searchEngine) {
        return this.count(searchEngine, 0.0f);
    }

    public long count(SearchEngine searchEngine, float minimumScore) {
        LuceneSearchEngineInternalSearch internalSearch = (LuceneSearchEngineInternalSearch)searchEngine.internalSearch(this.getSubIndexes(), this.getAliases());
        CountHitCollector countHitCollector = new CountHitCollector(minimumScore);
        try {
            if (internalSearch.getSearcher() == null) {
                return 0L;
            }
            internalSearch.getSearcher().search(this.getQuery(), this.getLuceneFilter(), (HitCollector)countHitCollector);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to count query [" + this.query + "]", e);
        }
        return countHitCollector.getTotalHits();
    }

    public SearchEngineQuery setBoost(float boost) {
        this.query.setBoost(boost);
        return this;
    }

    public SearchEngineQuery setSubIndexes(String[] subindexes) {
        this.subIndexes = subindexes;
        return this;
    }

    public String[] getSubIndexes() {
        return this.subIndexes;
    }

    public SearchEngineQuery setAliases(String[] aliases) {
        if (aliases == null) {
            this.query = this.origQuery;
            return this;
        }
        String aliasProperty = this.searchEngineFactory.getLuceneSettings().getAliasProperty();
        BooleanQuery boolQuery2 = new BooleanQuery();
        for (String alias : aliases) {
            boolQuery2.add((Query)new TermQuery(new Term(aliasProperty, alias)), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery boolQuery = new BooleanQuery();
        boolQuery.add(this.origQuery, BooleanClause.Occur.MUST);
        boolQuery.add((Query)boolQuery2, BooleanClause.Occur.MUST);
        this.query = boolQuery;
        this.aliases = aliases;
        return this;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public SearchEngineQuery setFilter(SearchEngineQueryFilter filter) {
        this.filter = (LuceneSearchEngineQueryFilter)filter;
        return this;
    }

    public LuceneSearchEngineQueryFilter getFilter() {
        return this.filter;
    }

    public Filter getLuceneFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getFilter();
    }

    public SearchEngineQuery rewrite() {
        this.rewrite = true;
        return this;
    }

    public boolean isRewrite() {
        return this.rewrite;
    }

    public boolean isSuggested() {
        return this.suggested;
    }

    public Query getOriginalQuery() {
        return this.origQuery;
    }

    public Query getQuery() {
        return this.query;
    }

    public String toString() {
        if (this.query == null) {
            return "<null>";
        }
        return this.query.toString().replace(this.defaultSearchProperty + ":", "");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setQuery(Query query) {
        this.query = query;
        this.origQuery = query;
    }

    public void setSuggested(boolean suggested) {
        this.suggested = suggested;
    }

    public static class LuceneSearchEngineSpanQuery
    extends LuceneSearchEngineQuery
    implements SearchEngineQuery.SearchEngineSpanQuery {
        private SpanQuery spanQuery;

        public LuceneSearchEngineSpanQuery(LuceneSearchEngineFactory searchEngineFactory, SpanQuery query) {
            super(searchEngineFactory, (Query)query);
            this.spanQuery = query;
        }

        public SpanQuery toSpanQuery() {
            return this.spanQuery;
        }
    }
}

