/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.executor.commonj;

import commonj.work.Work;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkCallableFutureAdapter<T>
implements Work,
Future<T> {
    private Callable<T> callable;
    private T result;
    private Exception exception;
    private volatile boolean done = false;
    private final Object monitor = new Object();

    public WorkCallableFutureAdapter(Callable<T> callable) {
        this.callable = callable;
    }

    public WorkCallableFutureAdapter(Runnable runnable) {
        this.callable = Executors.callable(runnable, null);
    }

    public boolean isDaemon() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.result = this.callable.call();
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            this.done = true;
            this.monitor.notifyAll();
        }
    }

    public void release() {
    }

    void setException(Exception e) {
        this.exception = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        while (!this.done) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait();
            }
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception.getMessage(), this.exception);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait(unit.toMillis(timeout));
            }
        }
        if (!this.done) {
            throw new TimeoutException("Timeout waiting for task to execute for [" + timeout + "]");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception.getMessage(), this.exception);
        }
        return this.result;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }
}

