/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem.collection;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.compass.core.converter.mapping.osem.collection.LazyReferenceCollection;
import org.compass.core.converter.mapping.osem.collection.LazyReferenceEntry;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.spi.InternalCompassSession;

public class LazyReferenceSet
extends AbstractSet
implements LazyReferenceCollection {
    private InternalCompassSession session;
    private final ArrayList<LazyReferenceEntry> entries;
    private Object[] objects;
    private Set objectSet;
    private AbstractCollectionMapping.CollectionType collectionType;
    private boolean fullyLoaded = false;

    public LazyReferenceSet(InternalCompassSession session, int size, AbstractCollectionMapping.CollectionType collectionType) {
        this.session = session;
        this.entries = new ArrayList(size);
        this.collectionType = collectionType;
        this.objects = new Object[size];
    }

    public void addLazyEntry(LazyReferenceEntry entry) {
        this.entries.add(entry);
    }

    public Iterator iterator() {
        if (this.fullyLoaded) {
            return this.objectSet.iterator();
        }
        return new InternalIterator();
    }

    public int size() {
        if (this.fullyLoaded) {
            return this.objectSet.size();
        }
        return this.entries.size();
    }

    public boolean add(Object o) {
        this.loadFully();
        return this.objectSet.add(o);
    }

    public boolean remove(Object o) {
        this.loadFully();
        return this.objectSet.remove(o);
    }

    public boolean removeAll(Collection c) {
        this.loadFully();
        return this.objectSet.removeAll(c);
    }

    public boolean contains(Object o) {
        if (this.fullyLoaded) {
            return this.objectSet.contains(o);
        }
        return super.contains(o);
    }

    public boolean addAll(Collection c) {
        this.loadFully();
        return this.objectSet.addAll(c);
    }

    public void clear() {
        this.fullyLoaded = true;
        if (this.objectSet != null) {
            this.objectSet.clear();
        } else {
            this.objectSet = this.createSet();
        }
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public void loadFully() {
        if (this.fullyLoaded) {
            return;
        }
        this.objectSet = this.createSet();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            this.objectSet.add(it.next());
        }
        this.objects = null;
        this.entries.clear();
        this.fullyLoaded = true;
    }

    private Set createSet() {
        if (this.collectionType == AbstractCollectionMapping.CollectionType.SET) {
            return new HashSet(this.entries.size());
        }
        if (this.collectionType == AbstractCollectionMapping.CollectionType.SORTED_SET) {
            return new TreeSet();
        }
        if (this.collectionType == AbstractCollectionMapping.CollectionType.LINKED_HASH_SET) {
            return new LinkedHashSet(this.entries.size());
        }
        throw new IllegalStateException("Should not happen, internal compass error");
    }

    private class InternalIterator
    implements Iterator {
        private int cursor;
        private Iterator dirtyIterator;

        private InternalIterator() {
        }

        public boolean hasNext() {
            if (this.dirtyIterator != null) {
                return this.dirtyIterator.hasNext();
            }
            return this.cursor < LazyReferenceSet.this.entries.size();
        }

        public Object next() {
            if (this.dirtyIterator != null) {
                return this.dirtyIterator.next();
            }
            Object obj = LazyReferenceSet.this.objects[this.cursor];
            if (obj == null) {
                ((LazyReferenceSet)LazyReferenceSet.this).objects[this.cursor] = obj = LazyReferenceSet.this.session.get(((LazyReferenceEntry)LazyReferenceSet.this.entries.get(this.cursor)).getAlias(), ((LazyReferenceEntry)LazyReferenceSet.this.entries.get(this.cursor)).getIds());
            }
            ++this.cursor;
            return obj;
        }

        public void remove() {
            LazyReferenceSet.this.loadFully();
            if (this.dirtyIterator != null) {
                this.dirtyIterator.remove();
            }
            this.dirtyIterator = LazyReferenceSet.this.objectSet.iterator();
            for (int i = 0; i < this.cursor; ++i) {
                this.dirtyIterator.next();
            }
            this.dirtyIterator.remove();
        }
    }
}

