/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.json;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.converter.json.JsonFullPathHolder;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.json.JsonPropertyMapping;
import org.compass.core.mapping.json.Naming;
import org.compass.core.marshall.MarshallingContext;

public class SimpleJsonValueConverter
implements Converter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        Property property;
        PropertyPath path;
        PropertyPath path2;
        Naming dynamicNaming;
        JsonPropertyMapping jsonPropertyMapping = (JsonPropertyMapping)mapping;
        if (root == null && !this.handleNulls(jsonPropertyMapping, context)) {
            return false;
        }
        String sValue = this.getNullValue(jsonPropertyMapping, context);
        if (root != null) {
            sValue = this.toString(root, jsonPropertyMapping, context);
        }
        String propertyName = jsonPropertyMapping.isDynamic() ? ((dynamicNaming = (Naming)((Object)context.getAttribute("$jsonDynamicNaming"))) != null && dynamicNaming == Naming.FULL ? ((JsonFullPathHolder)context.getAttribute("$jsonFullPathHolder")).calculatePath() : ((path2 = jsonPropertyMapping.getPath()) == null ? (String)context.getAttribute("$jsonDynamicPath") : path2.getPath())) : (jsonPropertyMapping.getNamingType() == Naming.FULL ? ((JsonFullPathHolder)context.getAttribute("$jsonFullPathHolder")).calculatePath() : ((path = jsonPropertyMapping.getPath()) == null ? (String)context.getAttribute("$jsonDynamicPath") : path.getPath()));
        if (jsonPropertyMapping.isDynamic() && root != null) {
            ResourcePropertyConverter converter = (ResourcePropertyConverter)context.getConverterLookup().lookupConverter(root.getClass());
            property = context.getResourceFactory().createProperty(propertyName, sValue, converter);
        } else {
            property = context.getResourceFactory().createProperty(propertyName, sValue, jsonPropertyMapping);
        }
        this.doSetBoost(property, root, jsonPropertyMapping, context);
        resource.addProperty(property);
        return jsonPropertyMapping.getStore() != Property.Store.NO;
    }

    protected boolean handleNulls(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.hasNullValue() || context.handleNulls();
    }

    protected String getNullValue(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.getNullValue();
    }

    protected void doSetBoost(Property property, Object root, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        property.setBoost(resourcePropertyMapping.getBoost());
    }

    protected String toString(Object value, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        ResourcePropertyConverter converter = (ResourcePropertyConverter)context.getConverterLookup().lookupConverter(value.getClass());
        return converter.toString(value, resourcePropertyMapping);
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        throw new ConversionException("Not supported");
    }
}

