/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.ParseException;
import org.compass.core.converter.basic.AbstractNumberConverter;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.NumberUtils;
import org.compass.core.mapping.ResourcePropertyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntConverter
extends AbstractNumberConverter<Integer> {
    @Override
    protected Integer defaultFromString(String str, ResourcePropertyMapping resourcePropertyMapping) {
        return Integer.valueOf(str);
    }

    @Override
    protected Integer fromNumber(Number number) {
        return number.intValue();
    }

    @Override
    protected Formatter createSortableFormatter() {
        return new Formatter(){

            public String format(Object obj) {
                int val = ((Number)obj).intValue();
                return NumberUtils.int2sortableStr(val);
            }

            public Object parse(String str) throws ParseException {
                return NumberUtils.SortableStr2int(str);
            }

            public boolean isThreadSafe() {
                return true;
            }
        };
    }
}

