/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassEnvironment;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.builder.ConfigurationBuilder;
import org.compass.core.config.builder.DTDConfigurationBuilder;
import org.compass.core.config.builder.JsonConfigurationBuilder;
import org.compass.core.config.builder.PropertiesConfigurationBuilder;
import org.compass.core.config.builder.SchemaConfigurationBuilder;

public class SmartConfigurationBuilder
implements ConfigurationBuilder {
    private static final Log log = LogFactory.getLog(SmartConfigurationBuilder.class);
    private static final int MAX_PEEK_LINES = 5;

    public void configure(String resource, CompassConfiguration config) throws ConfigurationException {
        InputStream stream = CompassEnvironment.class.getResourceAsStream(resource);
        if (stream == null) {
            throw new ConfigurationException("Failed to open config resource [" + resource + "]");
        }
        this.detect(stream, resource).configure(resource, config);
    }

    public void configure(URL url, CompassConfiguration config) throws ConfigurationException {
        InputStream stream;
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to open url [" + url.toExternalForm() + "]", e);
        }
        this.detect(stream, url.toExternalForm()).configure(url, config);
    }

    public void configure(File file, CompassConfiguration config) throws ConfigurationException {
        FileInputStream stream;
        try {
            stream = new FileInputStream(file);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not find configuration file [" + file.getAbsolutePath() + "]", e);
        }
        this.detect(stream, file.getAbsolutePath()).configure(file, config);
    }

    private ConfigurationBuilder detect(InputStream stream, String resourceName) {
        if (resourceName.endsWith(".properties")) {
            return new PropertiesConfigurationBuilder();
        }
        if (resourceName.endsWith(".json")) {
            return new JsonConfigurationBuilder();
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream));
            boolean isDtdValidated = false;
            for (int x = 0; x < 5 && (line = reader.readLine()) != null; ++x) {
                if (line.trim().startsWith("{")) {
                    JsonConfigurationBuilder jsonConfigurationBuilder = new JsonConfigurationBuilder();
                    return jsonConfigurationBuilder;
                }
                if (line.indexOf("DOCTYPE") <= -1) continue;
                DTDConfigurationBuilder dTDConfigurationBuilder = new DTDConfigurationBuilder();
                return dTDConfigurationBuilder;
            }
            SchemaConfigurationBuilder schemaConfigurationBuilder = new SchemaConfigurationBuilder();
            return schemaConfigurationBuilder;
        }
        catch (IOException ex) {
            throw new ConfigurationException("Unable to determine validation mode for [" + resourceName + "]. Did you attempt to load directly from a SAX InputSource?", ex);
        }
        finally {
            block20: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        if (!log.isWarnEnabled()) break block20;
                        log.warn((Object)("Unable to close BufferedReader for [" + resourceName + "]."), (Throwable)ex);
                    }
                }
            }
        }
    }
}

