/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.accessor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.compass.core.CompassException;
import org.compass.core.accessor.Getter;
import org.compass.core.accessor.PropertyAccessException;
import org.compass.core.accessor.PropertyAccessor;
import org.compass.core.accessor.PropertyNotFoundException;
import org.compass.core.accessor.Setter;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.reflection.ReflectionFactory;
import org.compass.core.util.reflection.ReflectionField;

public class DirectPropertyAccessor
implements PropertyAccessor,
CompassConfigurable {
    private CompassSettings settings;

    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
    }

    private static Field resolveField(Class origClass, Class clazz, String name) throws PropertyNotFoundException {
        Field field;
        if (clazz == null || clazz == Object.class) {
            throw new PropertyNotFoundException("field not found [" + name + "] in class [" + origClass.getName() + "]");
        }
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            field = DirectPropertyAccessor.resolveField(origClass, clazz.getSuperclass(), name);
        }
        if (!ClassUtils.isPublic(clazz, field)) {
            field.setAccessible(true);
        }
        return field;
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        try {
            return new DirectGetter(ReflectionFactory.getField(this.settings, DirectPropertyAccessor.resolveField(theClass, theClass, propertyName)), theClass, propertyName);
        }
        catch (NoSuchFieldException e) {
            throw new PropertyAccessException(e, "Failed to get field using reflection", false, theClass, propertyName);
        }
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        try {
            return new DirectSetter(ReflectionFactory.getField(this.settings, DirectPropertyAccessor.resolveField(theClass, theClass, propertyName)), theClass, propertyName);
        }
        catch (NoSuchFieldException e) {
            throw new PropertyAccessException(e, "Failed to get field using reflection", true, theClass, propertyName);
        }
    }

    public static final class DirectSetter
    implements Setter {
        private static final long serialVersionUID = 3832625071100277812L;
        private final transient ReflectionField field;
        private final Class clazz;
        private final String name;

        DirectSetter(ReflectionField field, Class clazz, String name) {
            this.field = field;
            this.clazz = clazz;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object target, Object value) throws CompassException {
            try {
                this.field.set(target, value);
            }
            catch (Exception e) {
                throw new PropertyAccessException(e, "could not set a field value by reflection", true, this.clazz, this.name);
            }
        }

        public String toString() {
            return "DirectSetter(" + this.clazz.getName() + '.' + this.name + ')';
        }
    }

    public static final class DirectGetter
    implements Getter {
        private static final long serialVersionUID = 3257848800692155955L;
        private final transient ReflectionField field;
        private final Class clazz;
        private final String name;

        DirectGetter(ReflectionField field, Class clazz, String name) {
            this.field = field;
            this.clazz = clazz;
            this.name = name;
        }

        public Object get(Object target) throws CompassException {
            try {
                return this.field.get(target);
            }
            catch (Exception e) {
                throw new PropertyAccessException(e, "could not get a field value by reflection", false, this.clazz, this.name);
            }
        }

        public String getName() {
            return this.name;
        }

        public Class getReturnType() {
            return this.field.getType();
        }

        public Type getGenericReturnType() {
            return this.field.getGenericType();
        }

        public Field getField() {
            return this.field.getField();
        }

        public String toString() {
            return "DirectGetter(" + this.clazz.getName() + '.' + this.name + ')';
        }
    }
}

