/*
 * Copyright 2004-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.compass.gps.device.jpa.extractor;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

import org.apache.openejb.persistence.JtaEntityManager;
import org.compass.gps.device.jpa.JpaGpsDeviceException;

/**
 * Extracts the native entity manager factory from a managed OpenEJB one. If Spring
 * has not wrapped the factory, will return it as is.
 *
 * @author kimchy
 */
public class OpenEjbNativeJpaExtractor implements NativeJpaExtractor {

    public EntityManagerFactory extractNative(EntityManagerFactory entityManagerFactory) throws JpaGpsDeviceException {
        return entityManagerFactory;
    }

    public EntityManager extractNative(EntityManager entityManager) throws JpaGpsDeviceException {
        if (entityManager instanceof JtaEntityManager) {
            return ((JtaEntityManager) entityManager).getDelegate();
        }
        return entityManager;
    }
}
