/*
 * Copyright 2004-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.compass.core.config.binding;

import java.io.InputStream;

import org.compass.core.config.ConfigurationException;
import org.compass.core.util.config.ConfigurationHelper;
import org.compass.core.util.config.JsonConfigurationHelperBuilder;

/**
 * @author kimchy
 */
public class JsonMetaDataBinding extends MetaDataBinding {

    public String[] getSuffixes() {
        return new String[]{".cmd.json"};
    }

    protected ConfigurationHelper doParseConfigurationHelper(InputStream is, String resourceName) throws ConfigurationException {
        JsonConfigurationHelperBuilder builder = new JsonConfigurationHelperBuilder();
        return builder.build(is, resourceName);
    }
}