/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.approval;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.util.Assert;

public class TokenServicesUserApprovalHandler
implements UserApprovalHandler,
InitializingBean {
    private static Log logger = LogFactory.getLog(TokenServicesUserApprovalHandler.class);
    private String approvalParameter = "user_oauth_approval";
    private AuthorizationServerTokenServices tokenServices;
    private OAuth2RequestFactory requestFactory;

    public void setApprovalParameter(String approvalParameter) {
        this.approvalParameter = approvalParameter;
    }

    public void setTokenServices(AuthorizationServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void setRequestFactory(OAuth2RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.tokenServices != null ? 1 : 0) != 0, (String)"AuthorizationServerTokenServices must be provided");
        Assert.state((this.requestFactory != null ? 1 : 0) != 0, (String)"OAuth2RequestFactory must be provided");
    }

    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        String flag = authorizationRequest.getApprovalParameters().get(this.approvalParameter);
        boolean approved = flag != null && flag.toLowerCase().equals("true");
        OAuth2Request storedOAuth2Request = this.requestFactory.createOAuth2Request(authorizationRequest);
        OAuth2Authentication authentication = new OAuth2Authentication(storedOAuth2Request, userAuthentication);
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Looking up existing token for ");
            builder.append("client_id=" + authorizationRequest.getClientId());
            builder.append(", scope=" + authorizationRequest.getScope());
            builder.append(" and username=" + userAuthentication.getName());
            logger.debug((Object)builder.toString());
        }
        OAuth2AccessToken accessToken = this.tokenServices.getAccessToken(authentication);
        logger.debug((Object)("Existing access token=" + accessToken));
        if (accessToken != null && !accessToken.isExpired()) {
            logger.debug((Object)("User already approved with token=" + accessToken));
            approved = true;
        } else {
            logger.debug((Object)"Checking explicit approval");
            approved = userAuthentication.isAuthenticated() && approved;
        }
        return approved;
    }

    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        return authorizationRequest;
    }

    public AuthorizationRequest updateAfterApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        return authorizationRequest;
    }
}

