/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.BaseRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2Request
extends BaseRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<String> resourceIds = new HashSet<String>();
    private Collection<? extends GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
    private boolean approved = false;
    private String redirectUri;
    private Set<String> responseTypes = new HashSet<String>();
    private Map<String, Serializable> extensions = new HashMap<String, Serializable>();

    public OAuth2Request(Map<String, String> requestParameters, String clientId, Collection<? extends GrantedAuthority> authorities, boolean approved, Set<String> scope, Set<String> resourceIds, String redirectUri, Set<String> responseTypes, Map<String, Serializable> extensionProperties) {
        super.setClientId(clientId);
        super.setRequestParameters(requestParameters);
        super.setScope(scope);
        if (resourceIds != null) {
            this.resourceIds = new HashSet<String>(resourceIds);
        }
        if (authorities != null) {
            this.authorities = new HashSet<GrantedAuthority>(authorities);
        }
        this.approved = approved;
        this.resourceIds = resourceIds;
        if (responseTypes != null) {
            this.responseTypes = new HashSet<String>(responseTypes);
        }
        this.redirectUri = redirectUri;
        if (extensionProperties != null) {
            this.extensions = extensionProperties;
        }
    }

    protected OAuth2Request(OAuth2Request other) {
        this(other.getRequestParameters(), other.getClientId(), other.getAuthorities(), other.isApproved(), other.getScope(), other.getResourceIds(), other.getRedirectUri(), other.getResponseTypes(), other.getExtensions());
    }

    protected OAuth2Request(String clientId) {
        super.setClientId(clientId);
    }

    protected OAuth2Request() {
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Set<String> getResponseTypes() {
        return this.responseTypes;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public Map<String, Serializable> getExtensions() {
        return this.extensions;
    }

    @Override
    protected void setClientId(String clientId) {
        throw new IllegalStateException("Can't set clientId on OAuth2Request");
    }

    @Override
    protected void setScope(Collection<String> scope) {
        throw new IllegalStateException("Can't set scope on OAuth2Request");
    }

    @Override
    protected void setRequestParameters(Map<String, String> requestParameters) {
        throw new IllegalStateException("Can't set request parameters on OAuth2Request");
    }

    public OAuth2Request createOAuth2Request(Map<String, String> parameters) {
        return new OAuth2Request(parameters, this.getClientId(), this.authorities, this.approved, this.getScope(), this.resourceIds, this.redirectUri, this.responseTypes, this.extensions);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.clientId);
        out.writeObject(new HashMap(this.requestParameters));
        out.writeObject(new HashSet(this.scope));
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.clientId = (String)in.readObject();
        this.requestParameters = (HashMap)in.readObject();
        this.scope = (HashSet)in.readObject();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.approved ? 1231 : 1237);
        result = 31 * result + (this.authorities == null ? 0 : ((Object)this.authorities).hashCode());
        result = 31 * result + (this.extensions == null ? 0 : ((Object)this.extensions).hashCode());
        result = 31 * result + (this.redirectUri == null ? 0 : this.redirectUri.hashCode());
        result = 31 * result + (this.resourceIds == null ? 0 : ((Object)this.resourceIds).hashCode());
        result = 31 * result + (this.responseTypes == null ? 0 : ((Object)this.responseTypes).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2Request other = (OAuth2Request)obj;
        if (this.approved != other.approved) {
            return false;
        }
        if (this.authorities == null ? other.authorities != null : !((Object)this.authorities).equals(other.authorities)) {
            return false;
        }
        if (this.extensions == null ? other.extensions != null : !((Object)this.extensions).equals(other.extensions)) {
            return false;
        }
        if (this.redirectUri == null ? other.redirectUri != null : !this.redirectUri.equals(other.redirectUri)) {
            return false;
        }
        if (this.resourceIds == null ? other.resourceIds != null : !((Object)this.resourceIds).equals(other.resourceIds)) {
            return false;
        }
        return !(this.responseTypes == null ? other.responseTypes != null : !((Object)this.responseTypes).equals(other.responseTypes));
    }
}

