/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOAuth2RequestValidator
implements OAuth2RequestValidator {
    @Override
    public void validateScope(Map<String, String> parameters, Set<String> clientScopes) {
        if (parameters.containsKey("scope") && clientScopes != null && !clientScopes.isEmpty()) {
            for (String scope : OAuth2Utils.parseParameterList(parameters.get("scope"))) {
                if (clientScopes.contains(scope)) continue;
                throw new InvalidScopeException("Invalid scope: " + scope, clientScopes);
            }
        }
    }
}

