/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.util.OAuth2Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseRequest {
    protected String clientId;
    protected Set<String> scope = new HashSet<String>();
    protected Map<String, String> requestParameters = Collections.unmodifiableMap(new HashMap());

    BaseRequest() {
    }

    public String getClientId() {
        return this.clientId;
    }

    protected void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    protected void setScope(Collection<String> scope) {
        String value;
        if (scope != null && scope.size() == 1 && ((value = scope.iterator().next()).contains(" ") || scope.contains(","))) {
            scope = OAuth2Utils.parseParameterList(value);
        }
        this.scope = Collections.unmodifiableSet(scope == null ? new LinkedHashSet() : new LinkedHashSet<String>(scope));
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    protected void setRequestParameters(Map<String, String> requestParameters) {
        if (requestParameters != null) {
            this.requestParameters = Collections.unmodifiableMap(requestParameters);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.requestParameters == null ? 0 : ((Object)this.requestParameters).hashCode());
        result = 31 * result + (this.scope == null ? 0 : ((Object)this.scope).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseRequest other = (BaseRequest)obj;
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.requestParameters == null ? other.requestParameters != null : !((Object)this.requestParameters).equals(other.requestParameters)) {
            return false;
        }
        return !(this.scope == null ? other.scope != null : !((Object)this.scope).equals(other.scope));
    }
}

