/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.BaseRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationRequest
extends BaseRequest {
    private Map<String, String> approvalParameters = Collections.unmodifiableMap(new HashMap());
    private String state;
    private Set<String> responseTypes = new HashSet<String>();
    private Set<String> resourceIds = new HashSet<String>();
    private Collection<? extends GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
    private boolean approved = false;
    private String redirectUri;
    private Map<String, Serializable> extensions = new HashMap<String, Serializable>();

    public AuthorizationRequest() {
    }

    public AuthorizationRequest(Map<String, String> authorizationParameters, Map<String, String> approvalParameters, String clientId, Set<String> scope, Set<String> resourceIds, Collection<? extends GrantedAuthority> authorities, boolean approved, String state, String redirectUri, Set<String> responseTypes) {
        super.setClientId(clientId);
        super.setRequestParameters(authorizationParameters);
        super.setScope(scope);
        if (resourceIds != null) {
            this.resourceIds = new HashSet<String>(resourceIds);
        }
        if (authorities != null) {
            this.authorities = new HashSet<GrantedAuthority>(authorities);
        }
        this.approved = approved;
        this.resourceIds = resourceIds;
        this.redirectUri = redirectUri;
        if (responseTypes != null) {
            this.responseTypes = responseTypes;
        }
        this.state = state;
    }

    public OAuth2Request createOAuth2Request() {
        return new OAuth2Request(this.getRequestParameters(), this.getClientId(), this.getAuthorities(), this.isApproved(), this.getScope(), this.getResourceIds(), this.getRedirectUri(), this.getResponseTypes(), this.getExtensions());
    }

    public AuthorizationRequest(String clientId, Collection<String> scopes) {
        super.setClientId(clientId);
        super.setScope(new HashSet<String>(scopes));
    }

    public void setResourceIdsAndAuthoritiesFromClientDetails(ClientDetails clientDetails) {
        this.setResourceIds(clientDetails.getResourceIds());
        this.setAuthorities(clientDetails.getAuthorities());
    }

    public Map<String, String> getApprovalParameters() {
        return this.approvalParameters;
    }

    public void setApprovalParameters(Map<String, String> approvalParameters) {
        this.approvalParameters = approvalParameters;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Set<String> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(Set<String> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        if (authorities != null) {
            this.authorities = new HashSet<GrantedAuthority>(authorities);
        }
    }

    public Map<String, Serializable> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Serializable> extensions) {
        this.extensions = extensions;
    }

    public void setResourceIds(Set<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    @Override
    public void setClientId(String clientId) {
        super.setClientId(clientId);
    }

    @Override
    public void setScope(Collection<String> scope) {
        super.setScope(scope);
    }

    @Override
    public void setRequestParameters(Map<String, String> requestParameters) {
        if (requestParameters != null) {
            this.requestParameters = Collections.unmodifiableMap(requestParameters);
        }
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.approvalParameters == null ? 0 : ((Object)this.approvalParameters).hashCode());
        result = 31 * result + (this.responseTypes == null ? 0 : ((Object)this.responseTypes).hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationRequest other = (AuthorizationRequest)obj;
        if (this.approvalParameters == null ? other.approvalParameters != null : !((Object)this.approvalParameters).equals(other.approvalParameters)) {
            return false;
        }
        if (this.responseTypes == null ? other.responseTypes != null : !((Object)this.responseTypes).equals(other.responseTypes)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }
}

