/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.FormatUtils;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.PluginReferential;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Sonar;
import org.sonar.updatecenter.common.UpdateCenter;
import org.sonar.updatecenter.common.Version;

public final class UpdateCenterDeserializer {
    private UpdateCenterDeserializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateCenter fromProperties(File file) throws IOException {
        FileInputStream in = FileUtils.openInputStream((File)file);
        try {
            Properties props = new Properties();
            props.load(in);
            UpdateCenter pluginReferential = UpdateCenterDeserializer.fromProperties(props);
            pluginReferential.setDate(new Date(file.lastModified()));
            UpdateCenter updateCenter = pluginReferential;
            return updateCenter;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static UpdateCenter fromProperties(Properties p) {
        String[] pluginKeys;
        String[] sonarVersions;
        Sonar sonar = new Sonar();
        Date date = FormatUtils.toDate(p.getProperty("date"), true);
        ArrayList plugins = Lists.newArrayList();
        for (String sonarVersion : sonarVersions = UpdateCenterDeserializer.getArray(p, "sonar.versions")) {
            Release release = new Release((Artifact)sonar, sonarVersion);
            String sonarPrefix = "sonar.";
            release.setChangelogUrl(UpdateCenterDeserializer.get(p, sonarPrefix + sonarVersion + ".changelogUrl"));
            release.setDescription(UpdateCenterDeserializer.get(p, sonarPrefix + sonarVersion + ".description"));
            release.setDownloadUrl(UpdateCenterDeserializer.get(p, sonarPrefix + sonarVersion + ".downloadUrl"));
            release.setDate(FormatUtils.toDate(UpdateCenterDeserializer.get(p, "sonar." + sonarVersion + ".date"), false));
            sonar.addRelease(release);
        }
        for (String pluginKey : pluginKeys = UpdateCenterDeserializer.getArray(p, "plugins")) {
            String[] pluginReleases;
            Plugin plugin = new Plugin(pluginKey);
            plugin.setName(UpdateCenterDeserializer.get(p, pluginKey, "name"));
            plugin.setDescription(UpdateCenterDeserializer.get(p, pluginKey, "description"));
            plugin.setCategory(UpdateCenterDeserializer.get(p, pluginKey, "category"));
            plugin.setHomepageUrl(UpdateCenterDeserializer.get(p, pluginKey, "homepageUrl"));
            plugin.setLicense(UpdateCenterDeserializer.get(p, pluginKey, "license"));
            plugin.setOrganization(UpdateCenterDeserializer.get(p, pluginKey, "organization"));
            plugin.setOrganizationUrl(UpdateCenterDeserializer.get(p, pluginKey, "organizationUrl"));
            plugin.setTermsConditionsUrl(UpdateCenterDeserializer.get(p, pluginKey, "termsConditionsUrl"));
            plugin.setIssueTrackerUrl(UpdateCenterDeserializer.get(p, pluginKey, "issueTrackerUrl"));
            plugin.setSourcesUrl(UpdateCenterDeserializer.get(p, pluginKey, "scm"));
            plugin.setDevelopers(Lists.newArrayList((Object[])UpdateCenterDeserializer.getArray(p, pluginKey, "developers")));
            for (String pluginVersion : pluginReleases = StringUtils.split((String)StringUtils.defaultIfEmpty((String)UpdateCenterDeserializer.get(p, pluginKey, "versions"), (String)""), (String)",")) {
                String[] requiredSonarVersions;
                Release release = new Release((Artifact)plugin, pluginVersion);
                plugin.addRelease(release);
                release.setDownloadUrl(UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".downloadUrl"));
                release.setChangelogUrl(UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".changelogUrl"));
                release.setDescription(UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".description"));
                release.setDate(FormatUtils.toDate(UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".date"), false));
                for (String requiredSonarVersion : requiredSonarVersions = StringUtils.split((String)StringUtils.defaultIfEmpty((String)UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".requiredSonarVersions"), (String)""), (String)",")) {
                    release.addRequiredSonarVersions(Version.create(requiredSonarVersion));
                }
            }
            plugins.add(plugin);
        }
        PluginReferential pluginReferential = PluginReferential.create(plugins);
        for (Plugin plugin : pluginReferential.getPlugins()) {
            for (Release release : plugin.getReleases()) {
                String[] requiredReleases;
                String parentKey = UpdateCenterDeserializer.get(p, plugin.getKey(), release.getVersion().getName() + ".parent");
                if (parentKey != null) {
                    pluginReferential.setParent(release, parentKey);
                }
                for (String requiresPluginKey : requiredReleases = StringUtils.split((String)StringUtils.defaultIfEmpty((String)UpdateCenterDeserializer.get(p, plugin.getKey(), release.getVersion().getName() + ".requirePlugins"), (String)""), (String)",")) {
                    Iterator split = Splitter.on((char)':').split((CharSequence)requiresPluginKey).iterator();
                    String requiredPluginReleaseKey = (String)split.next();
                    String requiredMinimumReleaseVersion = (String)split.next();
                    pluginReferential.addOutgoingDependency(release, requiredPluginReleaseKey, requiredMinimumReleaseVersion);
                }
            }
        }
        return UpdateCenter.create(pluginReferential, sonar).setDate(date);
    }

    private static String get(Properties props, String key) {
        return StringUtils.defaultIfEmpty((String)props.getProperty(key), null);
    }

    private static String get(Properties p, String pluginKey, String field) {
        return UpdateCenterDeserializer.get(p, pluginKey + "." + field);
    }

    private static String[] getArray(Properties props, String key) {
        return StringUtils.split((String)StringUtils.defaultIfEmpty((String)props.getProperty(key), (String)""), (String)",");
    }

    private static String[] getArray(Properties p, String pluginKey, String field) {
        return UpdateCenterDeserializer.getArray(p, pluginKey + "." + field);
    }
}

