/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    private final String executable;
    private final List<String> arguments = Lists.newArrayList();
    private final Map<String, String> env = Maps.newHashMap(System.getenv());
    private File directory;
    private boolean newShell = false;

    private Command(String executable) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)executable) ? 1 : 0) != 0, (Object)"Command executable can not be blank");
        this.executable = executable;
    }

    public String getExecutable() {
        return this.executable;
    }

    public List<String> getArguments() {
        return ImmutableList.copyOf(this.arguments);
    }

    public Command addArgument(String arg) {
        this.arguments.add(arg);
        return this;
    }

    public Command addArguments(List<String> args) {
        this.arguments.addAll(args);
        return this;
    }

    public Command addArguments(String[] args) {
        Collections.addAll(this.arguments, args);
        return this;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Command setDirectory(File d) {
        this.directory = d;
        return this;
    }

    public Command setEnvironmentVariable(String name, String value) {
        this.env.put(name, value);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return ImmutableMap.copyOf(this.env);
    }

    public boolean isNewShell() {
        return this.newShell;
    }

    public Command setNewShell(boolean b) {
        this.newShell = b;
        return this;
    }

    List<String> toStrings() {
        ImmutableList.Builder command = ImmutableList.builder();
        if (this.newShell) {
            if (SystemUtils.IS_OS_WINDOWS) {
                command.add((Object[])new String[]{"cmd", "/C", "call"});
            } else {
                command.add((Object)"sh");
            }
        }
        command.add((Object)this.executable);
        command.addAll(this.arguments);
        return command.build();
    }

    public String toCommandLine() {
        return Joiner.on((String)" ").join(this.toStrings());
    }

    public String toString() {
        return this.toCommandLine();
    }

    public static Command create(String executable) {
        return new Command(executable);
    }
}

